% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateBamCoverageByInterval.R
\name{calculateBamCoverageByInterval}
\alias{calculateBamCoverageByInterval}
\title{Function to calculate coverage from BAM file}
\usage{
calculateBamCoverageByInterval(
  bam.file,
  interval.file,
  output.file = NULL,
  index.file = bam.file,
  keep.duplicates = FALSE,
  ...
)
}
\arguments{
\item{bam.file}{Filename of a BAM file.}

\item{interval.file}{File specifying the intervals. Interval is expected in
first column in format CHR:START-END.}

\item{output.file}{Optionally, write minimal coverage file. Can be read with
the \code{\link{readCoverageFile}} function.}

\item{index.file}{The bai index. This is expected without the .bai file
suffix, see \code{?scanBam}.}

\item{keep.duplicates}{Keep or remove duplicated reads.}

\item{...}{Additional parameters passed to \code{ScanBamParam}.}
}
\value{
Returns total and average coverage by intervals.
}
\description{
Takes a BAM file and an interval file as input and returns coverage for each
interval. Coverage should be then GC-normalized using the
\code{\link{correctCoverageBias}} function before determining purity and
ploidy with \code{\link{runAbsoluteCN}}. Uses the \code{scanBam} function
and applies low quality, duplicate reads as well as secondary alignment
filters.
}
\examples{

bam.file <- system.file("extdata", "ex1.bam", package = "PureCN",
    mustWork = TRUE)
interval.file <- system.file("extdata", "ex1_intervals.txt",
    package = "PureCN", mustWork = TRUE)

# Calculate raw coverage from BAM file. These need to be corrected for
# GC-bias using the correctCoverageBias function before determining purity
# and ploidy.
coverage <- calculateBamCoverageByInterval(bam.file = bam.file,
    interval.file = interval.file)

}
\seealso{
\code{\link{preprocessIntervals}
\link{correctCoverageBias} \link{runAbsoluteCN}}
}
\author{
Markus Riester
}
