% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satuRn-framework.R
\docType{class}
\name{StatModel-class}
\alias{StatModel-class}
\alias{.StatModel}
\title{The StatModel class for satuRn}
\description{
The `StatModel` class contains a statistical model generated by 
the DTU analysis.

Models are created by the dedicated user-level function `fitDTU()`
or manually, using the `StatModel()` constructor.
In the former case, each quantitative feature is assigned its s
tatistical model and the models are stored as a variable in 
a `DataFrame` object, that in turn will  be stored in the `RowData` slot of 
a `SummarizedExperiment object`.
}
\section{Slots}{

\describe{
\item{\code{type}}{`character(1)` defining type of the used model. Default is
`"fitError"`, i.e. an error model. 
If not an error, class type will be `"glm"`.}

\item{\code{params}}{A `list()` containing the parameters of the fitted model.}

\item{\code{varPosterior}}{`numeric()` of posterior variance.}

\item{\code{dfPosterior}}{`numeric()` of posterior degrees of freedom.}
}}

\examples{
## A fully specified dummy model
myModel <- StatModel(
    type = "glm",
    params = list(x = 3, y = 7, b = 4),
    varPosterior = c(0.1, 0.2, 0.3),
    dfPosterior = c(6, 7, 8)
)
myModel
}
\author{
Jeroen Gilis
}
