% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_epred.R
\name{posterior_epred.brmsfit}
\alias{posterior_epred.brmsfit}
\alias{pp_expect}
\alias{posterior_epred}
\title{Draws from the Expected Value of the Posterior Predictive Distribution}
\usage{
\method{posterior_epred}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  re.form = NULL,
  resp = NULL,
  dpar = NULL,
  nlpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  sort = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used. \code{NA}
values within factors (excluding grouping variables) are interpreted as if
all dummy variables of this factor are zero. This allows, for instance, to
make predictions of the grand mean when using sum coding. \code{NA} values
within grouping variables are treated as a new level.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA} or \code{~0}, include no group-level effects.}

\item{re.form}{Alias of \code{re_formula}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{nlpar}{Optional name of a predicted non-linear parameter.
If specified, expected predictions of this parameters are returned.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{sort}{Logical. Only relevant for time series models.
Indicating whether to return predicted values in the original
order (\code{FALSE}; default) or in the order of the
time series (\code{TRUE}).}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
An \code{array} of draws. For
  categorical and ordinal models, the output is an S x N x C array.
  Otherwise, the output is an S x N matrix, where S is the number of
  posterior draws, N is the number of observations, and C is the number of
  categories. In multivariate models, an additional dimension is added to the
  output which indexes along the different response variables.
}
\description{
Compute posterior draws of the expected value of the posterior predictive
distribution. Can be performed for the data used to fit the model (posterior
predictive checks) or for new data. By definition, these predictions have
smaller variance than the posterior predictions performed by the
\code{\link{posterior_predict.brmsfit}} method. This is because only the
uncertainty in the expected value of the posterior predictive distribution is
incorporated in the draws computed by \code{posterior_epred} while the
residual error is ignored there. However, the estimated means of both methods
averaged across draws should be very similar.
}
\details{
\code{NA} values within factors in \code{newdata},
  are interpreted as if all dummy variables of this factor are
  zero. This allows, for instance, to make predictions of the grand mean
  when using sum coding.

In multilevel models, it is possible to
allow new levels of grouping factors to be used in the predictions.
This can be controlled via argument \code{allow_new_levels}.
New levels can be sampled in multiple ways, which can be controlled
via argument \code{sample_new_levels}. Both of these arguments are
documented in \code{\link{prepare_predictions}} along with several
other useful arguments to control specific aspects of the predictions.
}
\examples{
\dontrun{
## fit a model
fit <- brm(rating ~ treat + period + carry + (1|subject),
           data = inhaler)

## compute expected predictions
ppe <- posterior_epred(fit)
str(ppe)
}

}
