% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cmd_list_keep}
\alias{cmd_list_keep}
\title{keep entries from list of flags by name, name/value pair, or index}
\usage{
cmd_list_keep(flags, keep)
}
\arguments{
\item{flags}{named list output of cmd_list_interp}

\item{keep}{vector of flag entries to keep. Pass a character vector
to keep flags by name. Pass a named vector to keep flags by name/value
pairs. Pass a numeric vector to keep by position.}
}
\value{
flags list with values not in keep removed
}
\description{
keep entries from list of flags by name, name/value pair, or index
}
\examples{
exFlags <- list("flag1" = 2, "flag2" = "someText")
cmd_list_keep(exFlags, "flag1")
# will keep flag2 because its name and value match 'keep' vector
cmd_list_keep(exFlags, c("flag2" = "someText"))
# Will keep "flag1" by position index
cmd_list_keep(exFlags, 1)

# won't keep flag2 because its value isn't 'someText'
exFlags2 <- list("flag1" = 2, "flag2" = "otherText")
cmd_list_keep(exFlags, c("flag2" = "someText"))
}
