% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_edge_attrs.R
\name{set_edge_attrs}
\alias{set_edge_attrs}
\title{Set edge attribute values}
\usage{
set_edge_attrs(graph, edge_attr, values, from = NULL, to = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_attr}{The name of the attribute to set. Some examples are located in \code{\link[=edge_aes]{edge_aes()}}}

\item{values}{The values to be set for the chosen attribute for the chosen
edges.}

\item{from}{An optional vector of node IDs from which the edge is outgoing
for filtering list of nodes with outgoing edges in the graph.}

\item{to}{An optional vector of node IDs from which the edge is incoming for
filtering list of nodes with incoming edges in the graph.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, set edge attribute values for one
or more edges.
}
\examples{
# Create a simple graph
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Set attribute `color = "green"`
# for edges `1`->`4` and `3`->`1`
# in the graph
graph <-
  graph \%>\%
  set_edge_attrs(
    edge_attr = color,
    values = "green",
    from = c(1, 3),
    to = c(4, 1))

# Set attribute `color = "blue"`
# for all edges in the graph
graph <-
  graph \%>\%
  set_edge_attrs(
    edge_attr = color,
    values = "blue")

# Set attribute `color = "pink"`
# for all edges in graph outbound
# from node with ID value `1`
graph <-
  graph \%>\%
  set_edge_attrs(
    edge_attr = color,
    values = "pink",
    from = 1)

# Set attribute `color = "black"`
# for all edges in graph inbound
# to node with ID `1`
graph <-
  graph \%>\%
  set_edge_attrs(
    edge_attr = color,
    values = "black",
    to = 1)

}
\seealso{
Other edge creation and removal: 
\code{\link{add_edge}()},
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edge}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()}
}
\concept{edge creation and removal}
