% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_paths.R
\name{staticPath}
\alias{staticPath}
\alias{excludeStaticPath}
\title{Create a staticPath object}
\usage{
staticPath(
  path,
  indexhtml = NULL,
  fallthrough = NULL,
  html_charset = NULL,
  headers = NULL,
  validation = NULL
)

excludeStaticPath()
}
\arguments{
\item{path}{The local path.}

\item{indexhtml}{If an index.html file is present, should it be served up
when the client requests the static path or any subdirectory?}

\item{fallthrough}{With the default value, \code{FALSE}, if a request is made
for a file that doesn't exist, then httpuv will immediately send a 404
response from the background I/O thread, without needing to call back into
the main R thread. This offers the best performance. If the value is
\code{TRUE}, then instead of sending a 404 response, httpuv will call the
application's \code{call} function, and allow it to handle the request.}

\item{html_charset}{When HTML files are served, the value that will be
provided for \code{charset} in the Content-Type header. For example, with
the default value, \code{"utf-8"}, the header is \code{Content-Type:
  text/html; charset=utf-8}. If \code{""} is used, then no \code{charset}
will be added in the Content-Type header.}

\item{headers}{Additional headers and values that will be included in the
response.}

\item{validation}{An optional validation pattern. Presently, the only type of
validation supported is an exact string match of a header. For example, if
\code{validation} is \code{'"abc" = "xyz"'}, then HTTP requests must have a
header named \code{abc} (case-insensitive) with the value \code{xyz}
(case-sensitive). If a request does not have a matching header, than httpuv
will give a 403 Forbidden response. If the \code{character(0)} (the
default), then no validation check will be performed.}
}
\description{
The \code{staticPath} function creates a \code{staticPath} object. Note that
if any of the arguments (other than \code{path}) are \code{NULL}, then that
means that for this particular static path, it should inherit the behavior
from the staticPathOptions set for the application as a whole.
}
\details{
The \code{excludeStaticPath} function tells the application to ignore a
particular path for static serving. This is useful when you want to include a
path for static serving (like \code{"/"}) but then exclude a subdirectory of
it (like \code{"/dynamic"}) so that the subdirectory will always be passed to
the R code for handling requests. \code{excludeStaticPath} can be used not
only for directories; it can also exclude specific files.
}
\seealso{
\code{\link{staticPathOptions}}.
}
