% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peak.R
\name{find_peak}
\alias{find_peak}
\title{Find the peak date of an incidence curve}
\usage{
find_peak(x, pool = TRUE)
}
\arguments{
\item{x}{An \code{incidence} object.}

\item{pool}{If \code{TRUE} (default), any groups will be pooled before finding
a peak. If \code{FALSE}, separate peaks will be found for each group.}
}
\value{
The date of the (first) highest incidence in the data.
}
\description{
This function can be used to find the peak of an epidemic curve stored as an
\code{incidence} object.
}
\examples{

if (require(outbreaks) && require(ggplot2)) { withAutoprint({
  i <- incidence(fluH7N9_china_2013$date_of_onset)
  i
  plot(i)

  ## one simple bootstrap
  x <- bootstrap(i)
  x
  plot(x)

  ## find 95\% CI for peak time using bootstrap
  find_peak(i)


  ## show confidence interval
  plot(i) + geom_vline(xintercept = find_peak(i), col = "red", lty = 2)

})}

}
\seealso{
\code{\link[=estimate_peak]{estimate_peak()}} for bootstrap estimates of the peak time
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}, Zhian N. Kamvar
\email{zkamvar@gmail.com}
}
