% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{is_lang}
\alias{is_lang}
\alias{is_name}
\alias{is_call}
\alias{is_pairlist}
\alias{is_atomic}
\title{Is an object a language object?}
\usage{
is_lang(x)

is_name(x)

is_call(x)

is_pairlist(x)

is_atomic(x)
}
\arguments{
\item{x}{An object to test.}
}
\description{
These helpers are consistent wrappers around their base R equivalents.
A language object is either an atomic vector (typically a scalar), a
name (aka a symbol), a call, or a pairlist (used for function arguments).
}
\examples{
q1 <- quote(1)
is_lang(q1)
is_atomic(q1)

q2 <- quote(x)
is_lang(q2)
is_name(q2)

q3 <- quote(x + 1)
is_lang(q3)
is_call(q3)
}
\seealso{
\code{\link{as_name}()} and \code{\link{as_call}()} for coercion
  functions.
}
