% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unreachable_code_linter.R
\name{unreachable_code_linter}
\alias{unreachable_code_linter}
\title{Block unreachable code and comments following return statements}
\usage{
unreachable_code_linter()
}
\description{
Code after e.g. a \code{\link[=return]{return()}} or \code{\link[=stop]{stop()}}
or in deterministically false conditional loops like \verb{if (FALSE)} can't be reached;
typically this is vestigial code left after refactoring or sandboxing code, which
is fine for exploration, but shouldn't ultimately be checked in. Comments
meant for posterity should be placed \emph{before} the final \code{return()}.
}
\examples{
# will produce lints
code_lines <- "f <- function() {\n  return(1 + 1)\n  2 + 2\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = unreachable_code_linter()
)

code_lines <- "f <- if (FALSE) {\n 2 + 2\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = unreachable_code_linter()
)

code_lines <- "f <- while (FALSE) {\n 2 + 2\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = unreachable_code_linter()
)

# okay
code_lines <- "f <- function() {\n  return(1 + 1)\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = unreachable_code_linter()
)

code_lines <- "f <- if (foo) {\n 2 + 2\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = unreachable_code_linter()
)

code_lines <- "f <- while (foo) {\n 2 + 2\n}"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = unreachable_code_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=readability_linters]{readability}
}
