% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer_summary.R
\name{summary.lmerModLmerTest}
\alias{summary.lmerModLmerTest}
\title{Summary Method for Linear Mixed Models}
\usage{
\method{summary}{lmerModLmerTest}(object, ..., ddf = c("Satterthwaite",
  "Kenward-Roger", "lme4"))
}
\arguments{
\item{object}{an lmerModLmerTest object.}

\item{...}{additional arguments passed on to \code{lme4::summary.merMod}}

\item{ddf}{the method for computing the degrees of freedom and
t-statistics. \code{ddf="Satterthwaite"} (default) uses Satterthwaite's method;
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method,
\code{ddf = "lme4"} returns the lme4-summary i.e., using the summary
method for \code{lmerMod} objects as defined in the \pkg{lme4}-package and
ignores the \code{type} argument. Partial matching is allowed.}
}
\value{
A summary object with a coefficient table (a \code{matrix}) including
t-values and p-values. The coefficient table can be extracted with
\code{coef(summary(<my-model>))}.
}
\description{
Summaries of Linear Mixed Models with coefficient tables including t-tests
and p-values using Satterthwaites's or Kenward-Roger's methods for
degrees-of-freedom and t-statistics.
}
\details{
The returned object is of class
\code{c("summary.lmerModLmerTest", "summary.merMod")} utilizing \code{print},
\code{coef} and other methods defined for \code{summary.merMod} objects.
The \code{"Kenward-Roger"} method use methods from the \pkg{pbkrtest} package internally
to compute t-statistics and associated degrees-of-freedom.
}
\examples{

# Fit example model:
data("sleepstudy", package="lme4")
fm <- lmer(Reaction ~ Days + (1|Subject) + (0+Days|Subject), sleepstudy)

# Get model summary:
summary(fm) # Satterthwaite df and t-tests

# Extract coefficient table:
coef(summary(fm))

# Use the Kenward-Roger method
if(requireNamespace("pbkrtest", quietly = TRUE))
  summary(fm, ddf="Kenward-Roger")

# The lme4-summary table:
summary(fm, ddf="lme4") # same as summary(as(fm, "lmerMod"))

\dontshow{
  # Check that summaries are as expected:
  summ_fm <- coef(summary(fm))
  summ_fm_lme4 <- coef(summary(fm, ddf="lme4"))
  stopifnot(
    all(colnames(summ_fm) == c("Estimate", "Std. Error", "df", "t value", "Pr(>|t|)")),
    all(colnames(summ_fm_lme4) == c("Estimate", "Std. Error", "t value")),
    all(!(is.na(summ_fm))),
    all(!(is.na(summ_fm_lme4)))
  )
 if(requireNamespace("pbkrtest", quietly = TRUE) && getRversion() >= "3.3.3") {
    summ_fm_kr <- coef(summary(fm, ddf="Kenward-Roger"))
     stopifnot(
       all(colnames(summ_fm_kr) == c("Estimate", "Std. Error", "df", "t value", "Pr(>|t|)")),
       all(!(is.na(summ_fm_kr)))
    )
 }
}
}
\seealso{
\code{\link{contest1D}} for one degree-of-freedom contrast tests
and \code{\link[pbkrtest]{KRmodcomp}} for Kenward-Roger F-tests.
}
\author{
Rune Haubo B. Christensen and Alexandra Kuznetsova
}
