% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{createWorkbook}
\alias{createWorkbook}
\title{Create a new Workbook object}
\usage{
createWorkbook(
  creator = ifelse(.Platform$OS.type == "windows", Sys.getenv("USERNAME"),
    Sys.getenv("USER")),
  title = NULL,
  subject = NULL,
  category = NULL
)
}
\arguments{
\item{creator}{Creator of the workbook (your name). Defaults to login username}

\item{title}{Workbook properties title}

\item{subject}{Workbook properties subject}

\item{category}{Workbook properties category}
}
\value{
Workbook object
}
\description{
Create a new Workbook object
}
\examples{
## Create a new workbook
wb <- createWorkbook()

## Save workbook to working directory
\dontrun{saveWorkbook(wb, file = "createWorkbookExample.xlsx", overwrite = TRUE)}

## Set Workbook properties
wb <- createWorkbook(creator = "Me"
, title = "title here"
, subject = "this & that"
, category = "something")

}
\seealso{
\code{\link{loadWorkbook}}

\code{\link{saveWorkbook}}
}
\author{
Alexander Walker
}
