% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setAs-methods.R
\docType{methods}
\name{setAs}
\alias{setAs}
\alias{as}
\alias{as-method}
\alias{as,phylo,phylo4-method}
\alias{setAs}
\alias{as,phylo,phylo4d-method}
\alias{setAs}
\alias{as,nexml,phylo4-method}
\alias{setAs}
\alias{as,nexml,phylo4d-method}
\alias{setAs}
\alias{as,phylo4,phylo-method}
\alias{setAs}
\alias{setAs,phylo4,phylog-method}
\alias{setAs}
\alias{setAs,phylo4,data.frame-method}
\title{Converting between phylo4/phylo4d and other phylogenetic tree
formats}
\description{
Translation functions to convert between phylobase objects
(\code{phylo4} or \code{phylo4d}), and objects used by other
comparative methods packages in R: \code{ape} objects
(\code{phylo}, \code{multiPhylo}), \code{RNeXML} object
(\code{nexml}), \code{ade4} objects (\code{phylog}, \emph{now
deprecated}), and to \code{data.frame} representation.
}
\section{Usage}{
 \code{as(object, class)}
}

\examples{
tree_string <- "(((Strix_aluco:4.2,Asio_otus:4.2):3.1,Athene_noctua:7.3):6.3,Tyto_alba:13.5);"
tree.owls <- ape::read.tree(text=tree_string)
## round trip conversion
tree_in_phylo <- tree.owls                  # tree is a phylo object
(tree_in_phylo4 <- as(tree.owls,"phylo4"))  # phylo converted to phylo4
identical(tree_in_phylo,as(tree_in_phylo4,"phylo"))
## test if phylo, and phylo4 converted to phylo are identical
## (no, because of dimnames)

## Conversion to phylog (ade4)
as(tree_in_phylo4, "phylog")

## Conversion to data.frame
as(tree_in_phylo4, "data.frame")

## Conversion to phylo (ape)
as(tree_in_phylo4, "phylo")

## Conversion to phylo4d, (data slots empty)
as(tree_in_phylo4, "phylo4d")
}
\seealso{
generic \code{\link[methods]{as}},
\code{\link{phylo4-methods}}, \code{\link{phylo4d-methods}},
\code{\link{extractTree}}, \code{nexml} class from the
\code{RNeXML} package, \code{\link[ade4]{phylog}} from the
\code{ade4} package and \code{\link[ape]{as.phylo}} from the
\code{ape} package.
}
\author{
Ben Bolker, Thibaut Jombart, Marguerite Butler, Steve
Kembel, Francois Michonneau
}
\keyword{methods}
