% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations.R
\name{report_side_effects}
\alias{report_side_effects}
\title{Report side effects for expressions in test files}
\usage{
report_side_effects(
  report = TRUE,
  envvar = report,
  pwd = report,
  files = report,
  locale = report
)
}
\arguments{
\item{report}{\code{[logical]} report all side-effects}

\item{envvar}{\code{[logical]} changes in environment variables}

\item{pwd}{\code{[logical]} changes in working directory}

\item{files}{\code{[logical]} changes in files in the directory where the
test file lives. Also watches subdirectories.}

\item{locale}{\code{[logical]} Changes in locale settings as detected by 
\code{link[base]{Sys.getlocale}} are reported.}
}
\value{
A named \code{logical}, indicating which aspects of the environment
are tracked, invisibly.
}
\description{
Call this function from within a test file to report side effects.
}
\section{Details}{

A side effect causes a change in an external variable outside of the scope
of a function, or test file. This includes environment variables, global
options, global R variables, creating files or directories, and so on.

If this function is called in a test file, side effects are monitored from
that point in the file and only for that file. The state of the environment
before and after running every expression in the file are compared.

There is some performance penalty in tracking external variables, especially
for those that require a system call.
}

\section{Note}{

There could be side-effects that are untrackable by \pkg{tinytest}. This includes
packages that use a global internal state within their namespace or packages
that use a global state within compiled code.
}

\examples{
# switch on
report_side_effects()
# switch off
report_side_effects(FALSE)

# only report changes in environment variables
report_side_effects(report=FALSE, envvar=TRUE)

}
\concept{sidefx}
