<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

<style-sheet>
<style-specification>
<style-specification-body>

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This file is part of RefDB
;; Markus Hoenicka 011113
;; markus@mhoenicka.de
;; $Id: bibdb2tei.dsl,v 1.2 2002/12/13 20:33:48 mhoenicka Exp $
;;
;;
;;; The purpose of this stylesheet is to convert cooked DocBook 
;;; bibliographies into TEI bibliographies
;;; The current implemenation is limited to the elements that occur
;;; in the RefDB DocBook bibliography output
;
;;; Processing: jade -t xml -d bibdb2tei.dsl [sgml-declaration] docbook-file.sgml > tei-file.xml

(declare-flow-object-class element
			   "UNREGISTERED::James Clark//Flow Object Class::element")
(declare-flow-object-class processing-instruction
			   "UNREGISTERED::James Clark//Flow Object Class::processing-instruction")

(declare-flow-object-class document-type
  "UNREGISTERED::James Clark//Flow Object Class::document-type")

(element BIBLIOGRAPHY
  (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "refdb"))
      (make sequence
	(make processing-instruction 
	  data: "xml version=\"1.0\"")
	(make document-type
	  name: "listBibl"
	  system-id: "http://www.tei-c.org/P4X/DTD/tei2.dtd"
	  public-id: "-//TEI P4//DTD Main Document Type//EN")
	(make element
	  gi: "div"
	  attributes: (list (list "type" "refdb-bibliography"))
	  (with-mode div-mode (process-first-descendant "title"))
	  (make element
	    gi: "listBibl"
	    attributes: (list (list "rend" "refdb"))
	    (process-children))))
      (empty-sosofo)))

(mode div-mode
  (element (BIBLIOGRAPHY TITLE)
    (make sequence
      (make element
	gi: "head"
	(make element
	  gi: "title"
	  (process-children)))))
)

(element (BIBLIOGRAPHY TITLE)
  (empty-sosofo))

(element BIBLIOMIXED
  (make element
    gi: "bibl"
    attributes: (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "multixref"))
		    (list (list "rend" "multixref"))
		    (list
		     (list "id" (attribute-string (normalize "id")))
		     (list "rend" (attribute-string (normalize "role")))))
    (process-children)))

(element BIBLIOMSET
  (let ((relation (normalize (attribute-string (normalize "relation"))))
	(role (normalize (attribute-string (normalize "role")))))
    (cond
     ((equal? relation (normalize "author"))
      (make element
	gi: "persName"
	attributes: (list (list "type" "author"))
	(process-children)))
     ((equal? relation (normalize "editor"))
      (make element
	gi: "persName"
	attributes: (list (list "type" "editor"))
	(process-children)))
     ((equal? relation (normalize "seditor"))
      (make element
	gi: "persName"
	attributes: (list (list "type" "seditor"))
	(process-children)))
     ((equal? relation (normalize "article"))
      (make element
	gi: "seg"
	attributes: (list (list "type" "article"))
	(process-children)))
     (role
      (make element
	gi: "seg"
	attributes: (list (list "type" role)
			  (list "id" (attribute-string (normalize "id"))))
	(process-children)))
     (else
      (make element
	gi: "seg"
	attributes: (if (equal? relation (normalize "endtermtarget"))
			(list
			 (list "id" (attribute-string (normalize "id")))
			 (list "type" "endtermtarget"))
			(list (list "type" relation)))
	(process-children))))))

(element SURNAME
  (make element
    gi: "surname"
    (process-children)))

(element FIRSTNAME
  (make element
    gi: "foreName"
    (process-children)))

(element OTHERNAME
  (make element
    gi: "name"
    attributes: (list (list "type" "othername"))
    (process-children)))

(element LINEAGE
  (make element
    gi: "name"
    attributes: (list (list "type" "lineage"))
    (process-children)))

(element PUBDATE
  (make element
    gi: "date"
    attributes: (list (list "rend" (attribute-string (normalize "role"))))
    (process-children)))

(element TITLE
  (make element
    gi: "title"
    attributes: (cond
		 ((equal? (attribute-string (normalize "role")) "JOUR")
		  (list (list "level" "a")))
		 ((equal? (attribute-string (normalize "role")) "BOOK")
		  (list (list "level" "m")))
		 ((equal? (inherited-attribute-string (normalize "relation")) "journal")
		  (list (list "level" "j"))))
    (process-children)))
      
(element VOLUMENUM
  (make element
    gi: "seg"
    attributes: (list (list "type" "volume"))
    (process-children)))

(element ISSUENUM
  (make element
    gi: "seg"
    attributes: (list (list "type" "issue"))
    (process-children)))

(element PAGENUMS
  (make element
    gi: "seg"
    attributes:  (list (list "type" "pages"))
    (process-children)))

(element ADDRESS
  (make element
    gi: "address"
    (make element
      gi: "name"
      (process-children))))

(element ABBREV
  (make element
    gi: "abbr"
    (process-children)))

(element PUBLISHERNAME
  (make element
    gi: "publisher"
    (process-children)))

;; library functions

(define (normalize str)
  ;; REFENTRY normalize
  ;; PURP Normalize the str according to the SGML declaration in effect
  ;; DESC
  ;; Performs SGML general name normalization on the string;
  ;; used to compare attribute names and generic identifiers correctly
  ;; according to the SGML declaration in effect; this is necessary
  ;; since XML is case-sensitive but the reference concrete syntax and
  ;; many SGML DTDs are not.
  ;; /DESC
  ;; AUTHOR Chris Maden
  ;; /REFENTRY
  (if (string? str)
      (general-name-normalize str
			      (current-node))
      str))

</style-specification-body>
</style-specification>
</style-sheet>
