<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:php="http://php.net/xsl"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">



    <!-- ************************************************** -->
    <!--                                                                             -->
    <!--               Major bibliographic divisions                    -->
    <!--                                                                             -->
    <!-- ************************************************** -->

    <!-- part (analytic information) -->
    <xsl:template match="part">
        <xsl:if test="author!=''">
            <xsl:comment>part:author</xsl:comment>
            <xsl:apply-templates select="author"/>
            <xsl:text>. </xsl:text>
            <xsl:comment>/part:author</xsl:comment>
            <xsl:if
                test="../publication/pubinfo/pubdate[@type='primary']/date/year">
                <xsl:variable name="PYhref">
                    <xsl:value-of
                        select="../publication/pubinfo/pubdate[@type='primary']/date/year"/>
                </xsl:variable>
                <xsl:element name="a">
                    <xsl:attribute name="href"
                            >index.php?thisPage=Search%20results&amp;query=:PY:=<xsl:copy-of
                            select="php:function('urlencode',string($PYhref))"/></xsl:attribute>
                    <xsl:value-of
                        select="../publication/pubinfo/pubdate[@type='primary']/date/year"
                    />
                </xsl:element>
                <xsl:if
                    test="../publication/pubinfo/pubdate[@type='secondary']/date/year">
                    <xsl:variable name="Y2href">
                        <xsl:value-of
                            select="../publication/pubinfo/pubdate[@type='secondary']/date/year"/>
                    </xsl:variable>
                    <xsl:text> [</xsl:text>
                    <xsl:element name="a">
                        <xsl:attribute name="href"
                                >index.php?thisPage=Search%20results&amp;query=:PY:=<xsl:copy-of
                                select="php:function('urlencode',string($Y2href))"
                            /></xsl:attribute>
                        <xsl:value-of
                            select="../publication/pubinfo/pubdate[@type='primary']/date/year"
                        />
                    </xsl:element>
                    <xsl:text>]</xsl:text>
                </xsl:if>
                <xsl:text>. </xsl:text>
            </xsl:if>
        </xsl:if>
        <xsl:comment>part:title</xsl:comment>
        <xsl:if test="title!=''">
            <xsl:text>"</xsl:text>
            <xsl:apply-templates select="title"/>
            <xsl:text>."</xsl:text>
            <xsl:if test="../author=''">
                <xsl:if
                    test="../publication/pubinfo/pubdate[@type='primary']/date/year">
                    <xsl:value-of
                        select="../publication/pubinfo/pubdate[@type='primary']/date/year"/>
                    <xsl:text>. </xsl:text>
                </xsl:if>
            </xsl:if>
        </xsl:if>
        <xsl:comment>/part:title</xsl:comment>
        <xsl:text> </xsl:text>
    </xsl:template>

    <!-- publication (monographic information) -->
    <xsl:template match="publication">
        <xsl:choose>
            <xsl:when test="preceding-sibling::part!=''">
                <xsl:if test="title!=''">
                    <xsl:variable name="titlehref">
                        <xsl:value-of select="title"/>
                    </xsl:variable>
                    <xsl:variable name="relfreq">
                      <xsl:value-of select="@relfreq"/>
                    </xsl:variable>
                    <u>
                        <xsl:choose>
                            <xsl:when
                                test="parent::entry[@type='JOUR']|parent::entry[@type='JFULL']">
                              <span class='periodical relfreq{$relfreq}'>
                                <xsl:element name="a">
                                    <xsl:attribute name="href"
                                        >index.php?thisPage=Search%20results&amp;query=:JX:~<xsl:copy-of
                                        select="php:function('urlencode',string($titlehref))"
                                        /></xsl:attribute>
                                    <xsl:apply-templates select="title"/>
                                </xsl:element>
                              </span>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:element name="a">
                                    <xsl:attribute name="href"
                                        >index.php?thisPage=Search%20results&amp;query=:TX:~<xsl:copy-of
                                        select="php:function('urlencode',string($titlehref))"
                                        /></xsl:attribute>
                                    <xsl:apply-templates select="title"/>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </u>
                    <xsl:text>. </xsl:text>
                </xsl:if>
                <xsl:if test="author!=''">
                    <xsl:apply-templates select="author"/>
                    <xsl:text>, ed(s). </xsl:text>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="author!=''">
                    <xsl:apply-templates select="author"/>
                    <xsl:text> </xsl:text>
                </xsl:if>
                <xsl:apply-templates select="title"/>
                <xsl:text>. </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="pubinfo"/>
    </xsl:template>

    <!-- set (serial information) -->
    <xsl:template match="set">
        <xsl:apply-templates select="title"/>
        <xsl:text> </xsl:text>
        <xsl:if test="author">
            <xsl:apply-templates select="author"/>
            <xsl:text>, Series ed(s). </xsl:text>
        </xsl:if>
    </xsl:template>

    <!-- pubinfo (publication information) -->
    <xsl:template match="pubinfo">
        <xsl:if test="volume">
            <xsl:value-of select="volume"/>
            <xsl:if test="issue">
                <xsl:text>.</xsl:text>
                <xsl:value-of select="issue"/>
            </xsl:if>
            <xsl:if test="startpage">
                <xsl:text>: </xsl:text>
            </xsl:if>
        </xsl:if>
        <xsl:if test="startpage">
            <xsl:choose>
                <xsl:when test="volume!=''"> </xsl:when>
                <xsl:otherwise>
                    <xsl:text>p</xsl:text>
                    <xsl:if test="endpage!=''">
                        <xsl:text>p</xsl:text>
                    </xsl:if>
                    <xsl:text>. </xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="startpage"/>
            <xsl:if test="endpage">
                <xsl:text>-</xsl:text>
                <xsl:value-of select="endpage"/>
                <xsl:text>. </xsl:text>
            </xsl:if>
        </xsl:if>
        <xsl:if test="city">
            <xsl:value-of select="city"/>
        </xsl:if>
        <xsl:if test="publisher">
            <xsl:if test="city">
                <xsl:text>: </xsl:text>
            </xsl:if>
            <xsl:value-of select="publisher"/>
            <xsl:text>. </xsl:text>
        </xsl:if>
    </xsl:template>

    <!-- libinfo (local cataloguing information) -->
    <xsl:template match="libinfo">
        <xsl:if test="notes">
            <p>
                <strong>Bibliographic notes:</strong>
                <xsl:text> </xsl:text>
                <xsl:apply-templates select="notes"/>
            </p>
        </xsl:if>
        <xsl:if test="reprint">
            <p>
                <strong>Reprint status:</strong>
                <xsl:text> </xsl:text>
                <xsl:choose>
                  <xsl:when test="reprint/@status='ONREQUEST'">
                    <xsl:text>on request</xsl:text>
                  </xsl:when>
                  <xsl:when test="reprint/@status='INFILE'">
                    <xsl:text>in file</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>not in file</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="reprint/date">
                    <xsl:text> since </xsl:text>
                    <xsl:apply-templates select="reprint/date"/>
                </xsl:if>
            </p>
        </xsl:if>
        <xsl:if test="availability">
            <p>
                <strong>Location:</strong>
                <xsl:text> </xsl:text>
                <xsl:apply-templates select="availability"/>
            </p>
        </xsl:if>
        <xsl:if test="link">
          <xsl:apply-templates select="link"/>
        </xsl:if>
    </xsl:template>

    <!-- contents (abstract and notes) -->
    <xsl:template match="contents">
        <p>
            <strong>Keywords:</strong>
            <xsl:text> </xsl:text>
            <xsl:apply-templates select="keyword"/>
        </p>
        <xsl:if test="abstract!=''">
            <p>
                <strong>Abstract:</strong>
            </p>
            <blockquote>
                <p>
                    <xsl:apply-templates select="abstract"/>
                </p>
            </blockquote>
        </xsl:if>
    </xsl:template>


    <!-- author -->
    <!-- note: not added anything for @role yet -->
    <xsl:template match="author">
      <xsl:variable name="relfreq">
        <xsl:value-of select="@relfreq"/>
      </xsl:variable>
        <xsl:variable name="firstname">
            <xsl:value-of select="firstname"/>
        </xsl:variable>
        <xsl:variable name="middlename">
            <xsl:value-of select="middlename"/>
        </xsl:variable>
        <xsl:variable name="authorhref">
            <xsl:value-of select="lastname"/>
            <xsl:text>,</xsl:text>
            <xsl:choose>
                <xsl:when test="(string-length($firstname))=1">
                    <xsl:value-of select="firstname"/>
                    <xsl:text>.</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="firstname"/>
                    <xsl:if test="middlename!=''">
                        <xsl:text> </xsl:text>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="(string-length($middlename))=1">
                    <xsl:value-of select="middlename"/>
                    <xsl:text>.</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="middlename"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="preceding-sibling::author!=''">
                <xsl:choose>
                    <xsl:when test="following-sibling::author!=''">
                        <xsl:text>, </xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text> and </xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                <span class='author relfreq{$relfreq}'>
                <xsl:element name="a">
                    <xsl:attribute name="href"
                            >index.php?thisPage=Search%20results&amp;query=:AX:~<xsl:copy-of
                            select="php:function('urlencode',string($authorhref))"
                        /></xsl:attribute>
                    <xsl:if test="firstname!=''">
                        <xsl:apply-templates select="firstname"/>
                    </xsl:if>
                    <xsl:if test="middlename!=''">
                        <xsl:if test="./firstname">
                            <xsl:text> </xsl:text>
                        </xsl:if>
                        <xsl:apply-templates select="middlename"/>
                    </xsl:if>
                    <xsl:if test="lastname!=''">
                        <xsl:if test="./middlename|./firstname">
                            <xsl:text> </xsl:text>
                        </xsl:if>
                        <xsl:apply-templates select="lastname"/>
                    </xsl:if>
                    <xsl:if test="suffix!=''">
                        <xsl:if test="./middlename|./firstname|./lastname">
                            <xsl:text>, </xsl:text>
                        </xsl:if>
                        <xsl:apply-templates select="suffix"/>
                    </xsl:if>
                </xsl:element>
              </span>
            </xsl:when>
            <xsl:otherwise>
              <span class='author relfreq{$relfreq}'>
               <xsl:element name="a">
                    <xsl:attribute name="href"
                            >index.php?thisPage=Search%20results&amp;query=:AX:~<xsl:copy-of
                            select="php:function('urlencode',string($authorhref))"
                        /></xsl:attribute>
                    <xsl:if test="lastname!=''">
                        <xsl:apply-templates select="lastname"/>
                    </xsl:if>
                    <xsl:if test="firstname!=''">
                        <xsl:if test="./lastname">
                            <xsl:text>, </xsl:text>
                        </xsl:if>
                        <xsl:apply-templates select="firstname"/>
                    </xsl:if>
                    <xsl:if test="middlename!=''">
                        <xsl:if test="./firstname">
                            <xsl:text> </xsl:text>
                        </xsl:if>
                        <xsl:apply-templates select="middlename"/>
                    </xsl:if>
                    <xsl:if test="suffix!=''">
                        <xsl:if test="./middlename|./firstname|./lastname">
                            <xsl:text> </xsl:text>
                        </xsl:if>
                        <xsl:apply-templates select="suffix"/>
                    </xsl:if>
                </xsl:element>
              </span>
            </xsl:otherwise>
        </xsl:choose>


        <xsl:if test="suffix!=''">
            <xsl:text> </xsl:text>
            <xsl:apply-templates select="suffix"/>
        </xsl:if>
    </xsl:template>

    <!--  reprint -->
    <xsl:template match="reprint">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  pubdate -->
    <xsl:template match="pubdate">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  date -->
    <xsl:template match="date">
        <xsl:apply-templates/>
    </xsl:template>


    <!-- ************************************************** -->
    <!--                                                                             -->
    <!--                            Atomic elements                         -->
    <!--                                                                             -->
    <!-- ************************************************** -->

    <!--  availability -->
    <xsl:template match="availability">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- title -->
    <xsl:template match="title">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- lastname -->
    <xsl:template match="lastname">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- firstname -->
    <xsl:template match="firstname">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- middlename -->
    <xsl:template match="middlename">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- suffix -->
    <xsl:template match="suffix">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- abstract -->
    <xsl:template match="abstract">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- keyword -->
    <xsl:template match="keyword">
        <xsl:for-each select=".">
            <xsl:variable name="keyword">
                <xsl:value-of select="."/>
            </xsl:variable>
            <xsl:variable name="relfreq">
              <xsl:value-of select="@relfreq"/>
            </xsl:variable>
            <xsl:variable name="keywordhref">
                <xsl:copy-of
                    select="php:function('htmlentities',string($keyword))"/>
            </xsl:variable>
            <span class='keyword relfreq{$relfreq}'>
            <xsl:element name="a">
                <xsl:attribute name="href"
                        >index.php?thisPage=Search%20results&amp;query=:KW:~<xsl:copy-of
                        select="php:function('urlencode',string($keyword))"/></xsl:attribute>
                <xsl:apply-templates/>
            </xsl:element>
            </span>
            <xsl:choose>
                <xsl:when test="following-sibling::keyword">
                    <xsl:text>; </xsl:text>
                </xsl:when>
                <xsl:otherwise> </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <!--  notes -->
    <xsl:template match="notes">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  year -->
    <xsl:template match="year">
        <!-- xsl:apply-templates/ -->
    </xsl:template>

    <!--  month -->
    <xsl:template match="month">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  day -->
    <xsl:template match="day">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  otherinfo -->
    <xsl:template match="otherinfo">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  volume -->
    <xsl:template match="volume">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  issue -->
    <xsl:template match="issue">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  startpage -->
    <xsl:template match="startpage">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  endpage-->
    <xsl:template match="endpage">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  city -->
    <xsl:template match="city">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  publisher -->
    <xsl:template match="publisher">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  serial -->
    <xsl:template match="serial">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  address -->
    <xsl:template match="address">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  userdef -->
    <xsl:template match="userdef">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  misc -->
    <xsl:template match="misc">
        <xsl:apply-templates/>
    </xsl:template>

    <!--  link -->
    <xsl:template match="link">
      <xsl:variable name="target" select="."/>
      <xsl:choose>
        <xsl:when test="@type='doi'">
          <p><strong><xsl:value-of select="@type"/></strong>: <a href='http://dx.doi.org/{$target}'>
          <xsl:apply-templates/>
          </a></p>
        </xsl:when>
        <xsl:otherwise>        
          <p><strong><xsl:value-of select="@type"/></strong>: <a href='{$target}'>
          <xsl:apply-templates/>
          </a></p>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
