#ifndef _RHEOLEF_FIELD_CONCAT_H
#define _RHEOLEF_FIELD_CONCAT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// build field from initializer lists
//
#include "rheolef/field.h"
#include "rheolef/field_component.h"
#include "rheolef/space_mult.h"

namespace rheolef {

template <class T, class M>
struct field_concat_value {
// typedef:
 typedef enum { scalar, field} variant_type;
// allocators:
 field_concat_value (const T& x)                : s(x), f(),  variant(scalar) {}
 field_concat_value (const field_basic<T,M>& x) : s(),  f(x), variant(field) {}
// io/debug:
 friend std::ostream& operator<< (std::ostream& o, const field_concat_value<T,M>& x) {
  if (x.variant == scalar) return o << "s"; else return o << "f";
 }
// data:
public:
 T                    s;
 field_basic<T,M>     f;
 variant_type         variant;
};

template <class T, class M>
struct field_concat {
// typedef:
 typedef typename field_basic<T,M>::size_type   size_type;
 typedef field_concat_value<T,M>                value_type;

// allocators:

 field_concat () : _l() {}

#ifdef _RHEOLEF_HAVE_STD_INITIALIZER_LIST
 field_concat (const std::initializer_list<value_type>& il) : _l() {
#ifdef _RHEOLEF_HAVE_STD_INITIALIZER_ITERATOR
    typedef typename std::initializer_list<value_type>::const_iterator const_iterator;
#else // _RHEOLEF_HAVE_STD_INITIALIZER_ITERATOR
    typedef const value_type* const_iterator;
#endif // _RHEOLEF_HAVE_STD_INITIALIZER_ITERATOR
    for(const_iterator iter = il.begin(); iter != il.end(); ++iter) {
        _l.push_back(*iter);
    }
 }
#endif // _RHEOLEF_HAVE_STD_INITIALIZER_LIST

 friend std::ostream& operator<< (std::ostream& o, const field_concat<T,M>& x) {
    std::cout << "{";
    for(typename std::list<value_type>::const_iterator iter = x._l.begin(); iter != x._l.end(); ++iter) {
        std::cout << *iter << " ";
    }
    return std::cout << "}";
  }
  field_basic<T,M> build_field() const;
// data:
protected:
 std::list<value_type> _l;
};
template <class T, class M>
field_basic<T,M>
field_concat<T,M>::build_field() const
{
  // ------------------------------------
  // first pass: compute the field size
  // ------------------------------------
  space_mult_list<T,M> sml;
  for(typename std::list<value_type>::const_iterator iter = _l.begin(); iter != _l.end(); ++iter) {
    const field_concat_value<T,M>& x = *iter;
    if (x.variant == value_type::field) {
      sml *= x.f.get_space();
    } else {
      // TODO: IR space as 0d mesh and P1 ?
      fatal_macro("field initializer list: constant not yet supported");
    }
  }
  space_basic<T,M> Yh (sml);
  // ------------------------
  // second pass: copy values
  // ------------------------
  field_basic<T,M> yh (Yh);
  size_type i_comp = 0;
  for(typename std::list<value_type>::const_iterator iter = _l.begin(); iter != _l.end(); ++iter, i_comp++) {
    const field_concat_value<T,M>& x = *iter;
    if (x.variant == value_type::field) {
      yh [i_comp] = x.f;
    } else {
      fatal_macro("field initializer list: constant not yet supported");
    }
  }
#ifdef TODO
#endif // TODO
  return yh;
}
#ifdef _RHEOLEF_HAVE_STD_INITIALIZER_LIST
template <class T, class M>
inline
field_basic<T,M>::field_basic (const std::initializer_list<field_concat_value<T,M> >& init_list)
{
  field_concat<T,M> vc (init_list);
  field_basic<T,M>::operator= (vc.build_field());
}
template <class T, class M>
inline
field_basic<T,M>&
field_basic<T,M>::operator= (const std::initializer_list<field_concat_value<T,M> >& init_list)
{
  field_concat<T,M> vc (init_list);
  field_basic<T,M>::operator= (vc.build_field());
  return *this;
}
#endif // _RHEOLEF_HAVE_STD_INITIALIZER_LIST

} // namespace rheolef
#endif // _RHEOLEF_FIELD_CONCAT_H
