#![doc = r" This file is generated by `tools/generate-code`. DO NOT MODIFY."]
#![allow(unused_variables)]
#![allow(clippy::all)]
pub use ::swc_visit::All;
use swc_html_ast::*;
#[doc = r" A visitor trait for traversing the AST."]
pub trait Visit {
    #[doc = "Visit a node of type `swc_atoms :: Atom`.\n\nBy default, this method calls \
             [`swc_atoms :: Atom::visit_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_atom(&mut self, node: &swc_atoms::Atom) {
        <swc_atoms::Atom as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Attribute`.\n\nBy default, this method calls \
             [`Attribute::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_attribute(&mut self, node: &Attribute) {
        <Attribute as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `AttributeToken`.\n\nBy default, this method calls \
             [`AttributeToken::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_attribute_token(&mut self, node: &AttributeToken) {
        <AttributeToken as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < AttributeToken >`.\n\nBy default, this method calls [`Vec \
             < AttributeToken >::visit_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_attribute_tokens(&mut self, node: &[AttributeToken]) {
        <[AttributeToken] as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < Attribute >`.\n\nBy default, this method calls [`Vec < \
             Attribute >::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_attributes(&mut self, node: &[Attribute]) {
        <[Attribute] as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Child`.\n\nBy default, this method calls \
             [`Child::visit_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_child(&mut self, node: &Child) {
        <Child as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < Child >`.\n\nBy default, this method calls [`Vec < Child \
             >::visit_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_childs(&mut self, node: &[Child]) {
        <[Child] as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Comment`.\n\nBy default, this method calls \
             [`Comment::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_comment(&mut self, node: &Comment) {
        <Comment as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Document`.\n\nBy default, this method calls \
             [`Document::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_document(&mut self, node: &Document) {
        <Document as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentFragment`.\n\nBy default, this method calls \
             [`DocumentFragment::visit_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_document_fragment(&mut self, node: &DocumentFragment) {
        <DocumentFragment as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentMode`.\n\nBy default, this method calls \
             [`DocumentMode::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_document_mode(&mut self, node: &DocumentMode) {
        <DocumentMode as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentType`.\n\nBy default, this method calls \
             [`DocumentType::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_document_type(&mut self, node: &DocumentType) {
        <DocumentType as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Element`.\n\nBy default, this method calls \
             [`Element::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_element(&mut self, node: &Element) {
        <Element as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Namespace`.\n\nBy default, this method calls \
             [`Namespace::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_namespace(&mut self, node: &Namespace) {
        <Namespace as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < swc_atoms :: Atom >`.\n\nBy default, this method calls \
             [`Option < swc_atoms :: Atom >::visit_children_with`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_opt_atom(&mut self, node: &Option<swc_atoms::Atom>) {
        <Option<swc_atoms::Atom> as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < DocumentFragment >`.\n\nBy default, this method calls \
             [`Option < DocumentFragment >::visit_children_with`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_opt_document_fragment(&mut self, node: &Option<DocumentFragment>) {
        <Option<DocumentFragment> as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < Namespace >`.\n\nBy default, this method calls \
             [`Option < Namespace >::visit_children_with`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_opt_namespace(&mut self, node: &Option<Namespace>) {
        <Option<Namespace> as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < Raw >`.\n\nBy default, this method calls [`Option < \
             Raw >::visit_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_opt_raw(&mut self, node: &Option<Raw>) {
        <Option<Raw> as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Raw`.\n\nBy default, this method calls \
             [`Raw::visit_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_raw(&mut self, node: &Raw) {
        <Raw as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `swc_common :: Span`.\n\nBy default, this method calls \
             [`swc_common :: Span::visit_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_span(&mut self, node: &swc_common::Span) {
        <swc_common::Span as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Text`.\n\nBy default, this method calls \
             [`Text::visit_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_text(&mut self, node: &Text) {
        <Text as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `Token`.\n\nBy default, this method calls \
             [`Token::visit_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_token(&mut self, node: &Token) {
        <Token as VisitWith<Self>>::visit_children_with(node, self)
    }
    #[doc = "Visit a node of type `TokenAndSpan`.\n\nBy default, this method calls \
             [`TokenAndSpan::visit_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_token_and_span(&mut self, node: &TokenAndSpan) {
        <TokenAndSpan as VisitWith<Self>>::visit_children_with(node, self)
    }
}
impl<V> Visit for &mut V
where
    V: ?Sized + Visit,
{
    #[inline]
    fn visit_atom(&mut self, node: &swc_atoms::Atom) {
        <V as Visit>::visit_atom(&mut **self, node)
    }

    #[inline]
    fn visit_attribute(&mut self, node: &Attribute) {
        <V as Visit>::visit_attribute(&mut **self, node)
    }

    #[inline]
    fn visit_attribute_token(&mut self, node: &AttributeToken) {
        <V as Visit>::visit_attribute_token(&mut **self, node)
    }

    #[inline]
    fn visit_attribute_tokens(&mut self, node: &[AttributeToken]) {
        <V as Visit>::visit_attribute_tokens(&mut **self, node)
    }

    #[inline]
    fn visit_attributes(&mut self, node: &[Attribute]) {
        <V as Visit>::visit_attributes(&mut **self, node)
    }

    #[inline]
    fn visit_child(&mut self, node: &Child) {
        <V as Visit>::visit_child(&mut **self, node)
    }

    #[inline]
    fn visit_childs(&mut self, node: &[Child]) {
        <V as Visit>::visit_childs(&mut **self, node)
    }

    #[inline]
    fn visit_comment(&mut self, node: &Comment) {
        <V as Visit>::visit_comment(&mut **self, node)
    }

    #[inline]
    fn visit_document(&mut self, node: &Document) {
        <V as Visit>::visit_document(&mut **self, node)
    }

    #[inline]
    fn visit_document_fragment(&mut self, node: &DocumentFragment) {
        <V as Visit>::visit_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_document_mode(&mut self, node: &DocumentMode) {
        <V as Visit>::visit_document_mode(&mut **self, node)
    }

    #[inline]
    fn visit_document_type(&mut self, node: &DocumentType) {
        <V as Visit>::visit_document_type(&mut **self, node)
    }

    #[inline]
    fn visit_element(&mut self, node: &Element) {
        <V as Visit>::visit_element(&mut **self, node)
    }

    #[inline]
    fn visit_namespace(&mut self, node: &Namespace) {
        <V as Visit>::visit_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_opt_atom(&mut self, node: &Option<swc_atoms::Atom>) {
        <V as Visit>::visit_opt_atom(&mut **self, node)
    }

    #[inline]
    fn visit_opt_document_fragment(&mut self, node: &Option<DocumentFragment>) {
        <V as Visit>::visit_opt_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_opt_namespace(&mut self, node: &Option<Namespace>) {
        <V as Visit>::visit_opt_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_opt_raw(&mut self, node: &Option<Raw>) {
        <V as Visit>::visit_opt_raw(&mut **self, node)
    }

    #[inline]
    fn visit_raw(&mut self, node: &Raw) {
        <V as Visit>::visit_raw(&mut **self, node)
    }

    #[inline]
    fn visit_span(&mut self, node: &swc_common::Span) {
        <V as Visit>::visit_span(&mut **self, node)
    }

    #[inline]
    fn visit_text(&mut self, node: &Text) {
        <V as Visit>::visit_text(&mut **self, node)
    }

    #[inline]
    fn visit_token(&mut self, node: &Token) {
        <V as Visit>::visit_token(&mut **self, node)
    }

    #[inline]
    fn visit_token_and_span(&mut self, node: &TokenAndSpan) {
        <V as Visit>::visit_token_and_span(&mut **self, node)
    }
}
impl<V> Visit for Box<V>
where
    V: ?Sized + Visit,
{
    #[inline]
    fn visit_atom(&mut self, node: &swc_atoms::Atom) {
        <V as Visit>::visit_atom(&mut **self, node)
    }

    #[inline]
    fn visit_attribute(&mut self, node: &Attribute) {
        <V as Visit>::visit_attribute(&mut **self, node)
    }

    #[inline]
    fn visit_attribute_token(&mut self, node: &AttributeToken) {
        <V as Visit>::visit_attribute_token(&mut **self, node)
    }

    #[inline]
    fn visit_attribute_tokens(&mut self, node: &[AttributeToken]) {
        <V as Visit>::visit_attribute_tokens(&mut **self, node)
    }

    #[inline]
    fn visit_attributes(&mut self, node: &[Attribute]) {
        <V as Visit>::visit_attributes(&mut **self, node)
    }

    #[inline]
    fn visit_child(&mut self, node: &Child) {
        <V as Visit>::visit_child(&mut **self, node)
    }

    #[inline]
    fn visit_childs(&mut self, node: &[Child]) {
        <V as Visit>::visit_childs(&mut **self, node)
    }

    #[inline]
    fn visit_comment(&mut self, node: &Comment) {
        <V as Visit>::visit_comment(&mut **self, node)
    }

    #[inline]
    fn visit_document(&mut self, node: &Document) {
        <V as Visit>::visit_document(&mut **self, node)
    }

    #[inline]
    fn visit_document_fragment(&mut self, node: &DocumentFragment) {
        <V as Visit>::visit_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_document_mode(&mut self, node: &DocumentMode) {
        <V as Visit>::visit_document_mode(&mut **self, node)
    }

    #[inline]
    fn visit_document_type(&mut self, node: &DocumentType) {
        <V as Visit>::visit_document_type(&mut **self, node)
    }

    #[inline]
    fn visit_element(&mut self, node: &Element) {
        <V as Visit>::visit_element(&mut **self, node)
    }

    #[inline]
    fn visit_namespace(&mut self, node: &Namespace) {
        <V as Visit>::visit_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_opt_atom(&mut self, node: &Option<swc_atoms::Atom>) {
        <V as Visit>::visit_opt_atom(&mut **self, node)
    }

    #[inline]
    fn visit_opt_document_fragment(&mut self, node: &Option<DocumentFragment>) {
        <V as Visit>::visit_opt_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_opt_namespace(&mut self, node: &Option<Namespace>) {
        <V as Visit>::visit_opt_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_opt_raw(&mut self, node: &Option<Raw>) {
        <V as Visit>::visit_opt_raw(&mut **self, node)
    }

    #[inline]
    fn visit_raw(&mut self, node: &Raw) {
        <V as Visit>::visit_raw(&mut **self, node)
    }

    #[inline]
    fn visit_span(&mut self, node: &swc_common::Span) {
        <V as Visit>::visit_span(&mut **self, node)
    }

    #[inline]
    fn visit_text(&mut self, node: &Text) {
        <V as Visit>::visit_text(&mut **self, node)
    }

    #[inline]
    fn visit_token(&mut self, node: &Token) {
        <V as Visit>::visit_token(&mut **self, node)
    }

    #[inline]
    fn visit_token_and_span(&mut self, node: &TokenAndSpan) {
        <V as Visit>::visit_token_and_span(&mut **self, node)
    }
}
impl<A, B> Visit for ::swc_visit::Either<A, B>
where
    A: Visit,
    B: Visit,
{
    #[inline]
    fn visit_atom(&mut self, node: &swc_atoms::Atom) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_atom(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_atom(visitor, node),
        }
    }

    #[inline]
    fn visit_attribute(&mut self, node: &Attribute) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_attribute(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_attribute(visitor, node),
        }
    }

    #[inline]
    fn visit_attribute_token(&mut self, node: &AttributeToken) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_attribute_token(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_attribute_token(visitor, node),
        }
    }

    #[inline]
    fn visit_attribute_tokens(&mut self, node: &[AttributeToken]) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_attribute_tokens(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_attribute_tokens(visitor, node),
        }
    }

    #[inline]
    fn visit_attributes(&mut self, node: &[Attribute]) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_attributes(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_attributes(visitor, node),
        }
    }

    #[inline]
    fn visit_child(&mut self, node: &Child) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_child(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_child(visitor, node),
        }
    }

    #[inline]
    fn visit_childs(&mut self, node: &[Child]) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_childs(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_childs(visitor, node),
        }
    }

    #[inline]
    fn visit_comment(&mut self, node: &Comment) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_comment(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_comment(visitor, node),
        }
    }

    #[inline]
    fn visit_document(&mut self, node: &Document) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_document(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_document(visitor, node),
        }
    }

    #[inline]
    fn visit_document_fragment(&mut self, node: &DocumentFragment) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_document_fragment(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_document_fragment(visitor, node),
        }
    }

    #[inline]
    fn visit_document_mode(&mut self, node: &DocumentMode) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_document_mode(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_document_mode(visitor, node),
        }
    }

    #[inline]
    fn visit_document_type(&mut self, node: &DocumentType) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_document_type(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_document_type(visitor, node),
        }
    }

    #[inline]
    fn visit_element(&mut self, node: &Element) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_element(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_element(visitor, node),
        }
    }

    #[inline]
    fn visit_namespace(&mut self, node: &Namespace) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_namespace(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_namespace(visitor, node),
        }
    }

    #[inline]
    fn visit_opt_atom(&mut self, node: &Option<swc_atoms::Atom>) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_opt_atom(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_opt_atom(visitor, node),
        }
    }

    #[inline]
    fn visit_opt_document_fragment(&mut self, node: &Option<DocumentFragment>) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_opt_document_fragment(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_opt_document_fragment(visitor, node),
        }
    }

    #[inline]
    fn visit_opt_namespace(&mut self, node: &Option<Namespace>) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_opt_namespace(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_opt_namespace(visitor, node),
        }
    }

    #[inline]
    fn visit_opt_raw(&mut self, node: &Option<Raw>) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_opt_raw(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_opt_raw(visitor, node),
        }
    }

    #[inline]
    fn visit_raw(&mut self, node: &Raw) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_raw(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_raw(visitor, node),
        }
    }

    #[inline]
    fn visit_span(&mut self, node: &swc_common::Span) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_span(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_span(visitor, node),
        }
    }

    #[inline]
    fn visit_text(&mut self, node: &Text) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_text(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_text(visitor, node),
        }
    }

    #[inline]
    fn visit_token(&mut self, node: &Token) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_token(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_token(visitor, node),
        }
    }

    #[inline]
    fn visit_token_and_span(&mut self, node: &TokenAndSpan) {
        match self {
            swc_visit::Either::Left(visitor) => Visit::visit_token_and_span(visitor, node),
            swc_visit::Either::Right(visitor) => Visit::visit_token_and_span(visitor, node),
        }
    }
}
impl<V> Visit for ::swc_visit::Optional<V>
where
    V: Visit,
{
    #[inline]
    fn visit_atom(&mut self, node: &swc_atoms::Atom) {
        if self.enabled {
            <V as Visit>::visit_atom(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_attribute(&mut self, node: &Attribute) {
        if self.enabled {
            <V as Visit>::visit_attribute(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_attribute_token(&mut self, node: &AttributeToken) {
        if self.enabled {
            <V as Visit>::visit_attribute_token(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_attribute_tokens(&mut self, node: &[AttributeToken]) {
        if self.enabled {
            <V as Visit>::visit_attribute_tokens(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_attributes(&mut self, node: &[Attribute]) {
        if self.enabled {
            <V as Visit>::visit_attributes(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_child(&mut self, node: &Child) {
        if self.enabled {
            <V as Visit>::visit_child(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_childs(&mut self, node: &[Child]) {
        if self.enabled {
            <V as Visit>::visit_childs(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_comment(&mut self, node: &Comment) {
        if self.enabled {
            <V as Visit>::visit_comment(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_document(&mut self, node: &Document) {
        if self.enabled {
            <V as Visit>::visit_document(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_document_fragment(&mut self, node: &DocumentFragment) {
        if self.enabled {
            <V as Visit>::visit_document_fragment(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_document_mode(&mut self, node: &DocumentMode) {
        if self.enabled {
            <V as Visit>::visit_document_mode(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_document_type(&mut self, node: &DocumentType) {
        if self.enabled {
            <V as Visit>::visit_document_type(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_element(&mut self, node: &Element) {
        if self.enabled {
            <V as Visit>::visit_element(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_namespace(&mut self, node: &Namespace) {
        if self.enabled {
            <V as Visit>::visit_namespace(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_opt_atom(&mut self, node: &Option<swc_atoms::Atom>) {
        if self.enabled {
            <V as Visit>::visit_opt_atom(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_opt_document_fragment(&mut self, node: &Option<DocumentFragment>) {
        if self.enabled {
            <V as Visit>::visit_opt_document_fragment(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_opt_namespace(&mut self, node: &Option<Namespace>) {
        if self.enabled {
            <V as Visit>::visit_opt_namespace(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_opt_raw(&mut self, node: &Option<Raw>) {
        if self.enabled {
            <V as Visit>::visit_opt_raw(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_raw(&mut self, node: &Raw) {
        if self.enabled {
            <V as Visit>::visit_raw(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_span(&mut self, node: &swc_common::Span) {
        if self.enabled {
            <V as Visit>::visit_span(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_text(&mut self, node: &Text) {
        if self.enabled {
            <V as Visit>::visit_text(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_token(&mut self, node: &Token) {
        if self.enabled {
            <V as Visit>::visit_token(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_token_and_span(&mut self, node: &TokenAndSpan) {
        if self.enabled {
            <V as Visit>::visit_token_and_span(&mut self.visitor, node)
        } else {
        }
    }
}
#[doc = r" A trait implemented for types that can be visited using a visitor."]
pub trait VisitWith<V: ?Sized + Visit> {
    #[doc = r" Calls a visitor method (visitor.fold_xxx) with self."]
    fn visit_with(&self, visitor: &mut V);
    #[doc = r" Visit children nodes of `self`` with `visitor`."]
    fn visit_children_with(&self, visitor: &mut V);
}
impl<V: ?Sized + Visit> VisitWith<V> for Attribute {
    #[doc = "Calls [Visit`::visit_attribute`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_attribute(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Attribute {
                span,
                namespace,
                prefix,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <Option<Namespace> as VisitWith<V>>::visit_with(namespace, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(prefix, visitor)
                };
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(value, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw_value, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for AttributeToken {
    #[doc = "Calls [Visit`::visit_attribute_token`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_attribute_token(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            AttributeToken {
                span,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(value, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw_value, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Child {
    #[doc = "Calls [Visit`::visit_child`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_child(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Child::DocumentType { 0: _field_0 } => {
                <DocumentType as VisitWith<V>>::visit_with(_field_0, visitor);
            }
            Child::Element { 0: _field_0 } => {
                <Element as VisitWith<V>>::visit_with(_field_0, visitor);
            }
            Child::Text { 0: _field_0 } => {
                <Text as VisitWith<V>>::visit_with(_field_0, visitor);
            }
            Child::Comment { 0: _field_0 } => {
                <Comment as VisitWith<V>>::visit_with(_field_0, visitor);
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Comment {
    #[doc = "Calls [Visit`::visit_comment`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_comment(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Comment { span, data, raw } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(data, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Document {
    #[doc = "Calls [Visit`::visit_document`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_document(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Document {
                span,
                mode,
                children,
            } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <DocumentMode as VisitWith<V>>::visit_with(mode, visitor)
                };
                {
                    <Vec<Child> as VisitWith<V>>::visit_with(children, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for DocumentFragment {
    #[doc = "Calls [Visit`::visit_document_fragment`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_document_fragment(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            DocumentFragment { span, children } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <Vec<Child> as VisitWith<V>>::visit_with(children, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for DocumentMode {
    #[doc = "Calls [Visit`::visit_document_mode`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_document_mode(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            DocumentMode::NoQuirks => {}
            DocumentMode::LimitedQuirks => {}
            DocumentMode::Quirks => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for DocumentType {
    #[doc = "Calls [Visit`::visit_document_type`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_document_type(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            DocumentType {
                span,
                name,
                public_id,
                system_id,
                raw,
            } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(public_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(system_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Element {
    #[doc = "Calls [Visit`::visit_element`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_element(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Element {
                span,
                tag_name,
                namespace,
                attributes,
                children,
                content,
                is_self_closing,
            } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(tag_name, visitor)
                };
                {
                    <Namespace as VisitWith<V>>::visit_with(namespace, visitor)
                };
                {
                    <Vec<Attribute> as VisitWith<V>>::visit_with(attributes, visitor)
                };
                {
                    <Vec<Child> as VisitWith<V>>::visit_with(children, visitor)
                };
                {
                    <Option<DocumentFragment> as VisitWith<V>>::visit_with(content, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Namespace {
    #[doc = "Calls [Visit`::visit_namespace`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_namespace(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Namespace::HTML => {}
            Namespace::MATHML => {}
            Namespace::SVG => {}
            Namespace::XLINK => {}
            Namespace::XML => {}
            Namespace::XMLNS => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Raw {
    #[doc = "Calls [Visit`::visit_raw`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_raw(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Raw::Same => {}
            Raw::Atom { 0: _field_0 } => {
                <swc_atoms::Atom as VisitWith<V>>::visit_with(_field_0, visitor);
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Text {
    #[doc = "Calls [Visit`::visit_text`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_text(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Text { span, data, raw } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(data, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Token {
    #[doc = "Calls [Visit`::visit_token`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_token(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Token::Doctype {
                name,
                force_quirks,
                public_id,
                system_id,
                raw,
            } => {
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(public_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(system_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw, visitor)
                };
            }
            Token::StartTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(tag_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw_tag_name, visitor)
                };
                {
                    <Vec<AttributeToken> as VisitWith<V>>::visit_with(attributes, visitor)
                };
            }
            Token::EndTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(tag_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw_tag_name, visitor)
                };
                {
                    <Vec<AttributeToken> as VisitWith<V>>::visit_with(attributes, visitor)
                };
            }
            Token::Comment { data, raw } => {
                {
                    <swc_atoms::Atom as VisitWith<V>>::visit_with(data, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitWith<V>>::visit_with(raw, visitor)
                };
            }
            Token::Character { value, raw } => {
                {
                    <Option<Raw> as VisitWith<V>>::visit_with(raw, visitor)
                };
            }
            Token::Eof => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for TokenAndSpan {
    #[doc = "Calls [Visit`::visit_token_and_span`] with `self`."]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_token_and_span(visitor, self)
    }

    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            TokenAndSpan { span, token } => {
                {
                    <swc_common::Span as VisitWith<V>>::visit_with(span, visitor)
                };
                {
                    <Token as VisitWith<V>>::visit_with(token, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for swc_atoms::Atom {
    #[doc = "Calls [Visit`::visit_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_atom(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        {}
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for [AttributeToken] {
    #[doc = "Calls [Visit`::visit_attribute_tokens`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_attribute_tokens(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        self.iter()
            .for_each(|item| <AttributeToken as VisitWith<V>>::visit_with(item, visitor))
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for [Attribute] {
    #[doc = "Calls [Visit`::visit_attributes`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_attributes(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        self.iter()
            .for_each(|item| <Attribute as VisitWith<V>>::visit_with(item, visitor))
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for [Child] {
    #[doc = "Calls [Visit`::visit_childs`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_childs(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        self.iter()
            .for_each(|item| <Child as VisitWith<V>>::visit_with(item, visitor))
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Option<swc_atoms::Atom> {
    #[doc = "Calls [Visit`::visit_opt_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_opt_atom(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Some(inner) => <swc_atoms::Atom as VisitWith<V>>::visit_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Option<DocumentFragment> {
    #[doc = "Calls [Visit`::visit_opt_document_fragment`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_opt_document_fragment(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Some(inner) => <DocumentFragment as VisitWith<V>>::visit_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Option<Namespace> {
    #[doc = "Calls [Visit`::visit_opt_namespace`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_opt_namespace(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Some(inner) => <Namespace as VisitWith<V>>::visit_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for Option<Raw> {
    #[doc = "Calls [Visit`::visit_opt_raw`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_opt_raw(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        match self {
            Some(inner) => <Raw as VisitWith<V>>::visit_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + Visit> VisitWith<V> for swc_common::Span {
    #[doc = "Calls [Visit`::visit_span`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        <V as Visit>::visit_span(visitor, self)
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        {}
    }
}
impl<V, T> VisitWith<V> for std::boxed::Box<T>
where
    V: ?Sized + Visit,
    T: VisitWith<V>,
{
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        let v = <T as VisitWith<V>>::visit_with(&**self, visitor);
        v
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        let v = <T as VisitWith<V>>::visit_children_with(&**self, visitor);
        v
    }
}
impl<V, T> VisitWith<V> for std::vec::Vec<T>
where
    V: ?Sized + Visit,
    [T]: VisitWith<V>,
{
    #[inline]
    fn visit_with(&self, visitor: &mut V) {
        let v = <[T] as VisitWith<V>>::visit_with(self, visitor);
        v
    }

    #[inline]
    fn visit_children_with(&self, visitor: &mut V) {
        let v = <[T] as VisitWith<V>>::visit_children_with(self, visitor);
        v
    }
}
#[doc = r" A visitor trait for traversing the AST."]
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
pub trait VisitAstPath {
    #[doc = "Visit a node of type `swc_atoms :: Atom`.\n\nBy default, this method calls \
             [`swc_atoms :: Atom::visit_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_atoms::Atom,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <swc_atoms::Atom as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Attribute`.\n\nBy default, this method calls \
             [`Attribute::visit_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_attribute<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Attribute,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Attribute as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `AttributeToken`.\n\nBy default, this method calls \
             [`AttributeToken::visit_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_attribute_token<'ast: 'r, 'r>(
        &mut self,
        node: &'ast AttributeToken,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <AttributeToken as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < AttributeToken >`.\n\nBy default, this method calls [`Vec \
             < AttributeToken >::visit_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_attribute_tokens<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [AttributeToken],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <[AttributeToken] as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < Attribute >`.\n\nBy default, this method calls [`Vec < \
             Attribute >::visit_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_attributes<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Attribute],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <[Attribute] as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Child`.\n\nBy default, this method calls \
             [`Child::visit_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_child<'ast: 'r, 'r>(&mut self, node: &'ast Child, __ast_path: &mut AstNodePath<'r>) {
        <Child as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Vec < Child >`.\n\nBy default, this method calls [`Vec < Child \
             >::visit_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_childs<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Child],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <[Child] as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Comment`.\n\nBy default, this method calls \
             [`Comment::visit_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_comment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Comment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Comment as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Document`.\n\nBy default, this method calls \
             [`Document::visit_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_document<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Document,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Document as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `DocumentFragment`.\n\nBy default, this method calls \
             [`DocumentFragment::visit_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentFragment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <DocumentFragment as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `DocumentMode`.\n\nBy default, this method calls \
             [`DocumentMode::visit_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_document_mode<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentMode,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <DocumentMode as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `DocumentType`.\n\nBy default, this method calls \
             [`DocumentType::visit_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_document_type<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentType,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <DocumentType as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Element`.\n\nBy default, this method calls \
             [`Element::visit_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_element<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Element,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Element as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Namespace`.\n\nBy default, this method calls \
             [`Namespace::visit_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Namespace,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Namespace as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Option < swc_atoms :: Atom >`.\n\nBy default, this method calls \
             [`Option < swc_atoms :: Atom >::visit_children_with_ast_path`]. If you want to \
             recurse, you need to call it manually."]
    #[inline]
    fn visit_opt_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<swc_atoms::Atom>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Option<swc_atoms::Atom> as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < DocumentFragment >`.\n\nBy default, this method calls \
             [`Option < DocumentFragment >::visit_children_with_ast_path`]. If you want to \
             recurse, you need to call it manually."]
    #[inline]
    fn visit_opt_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<DocumentFragment>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Option<DocumentFragment> as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < Namespace >`.\n\nBy default, this method calls \
             [`Option < Namespace >::visit_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_opt_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Namespace>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Option<Namespace> as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < Raw >`.\n\nBy default, this method calls [`Option < \
             Raw >::visit_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_opt_raw<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Raw>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <Option<Raw> as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Raw`.\n\nBy default, this method calls \
             [`Raw::visit_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_raw<'ast: 'r, 'r>(&mut self, node: &'ast Raw, __ast_path: &mut AstNodePath<'r>) {
        <Raw as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `swc_common :: Span`.\n\nBy default, this method calls \
             [`swc_common :: Span::visit_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_common::Span,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <swc_common::Span as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Text`.\n\nBy default, this method calls \
             [`Text::visit_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_text<'ast: 'r, 'r>(&mut self, node: &'ast Text, __ast_path: &mut AstNodePath<'r>) {
        <Text as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Token`.\n\nBy default, this method calls \
             [`Token::visit_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_token<'ast: 'r, 'r>(&mut self, node: &'ast Token, __ast_path: &mut AstNodePath<'r>) {
        <Token as VisitWithAstPath<Self>>::visit_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `TokenAndSpan`.\n\nBy default, this method calls \
             [`TokenAndSpan::visit_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_token_and_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast TokenAndSpan,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <TokenAndSpan as VisitWithAstPath<Self>>::visit_children_with_ast_path(
            node, self, __ast_path,
        )
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> VisitAstPath for &mut V
where
    V: ?Sized + VisitAstPath,
{
    #[inline]
    fn visit_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_atoms::Atom,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attribute<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Attribute,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attribute_token<'ast: 'r, 'r>(
        &mut self,
        node: &'ast AttributeToken,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attribute_tokens<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [AttributeToken],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute_tokens(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attributes<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Attribute],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attributes(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_child<'ast: 'r, 'r>(&mut self, node: &'ast Child, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_child(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_childs<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Child],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_childs(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_comment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Comment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_comment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Document,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentFragment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document_mode<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentMode,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_mode(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document_type<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentType,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_type(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_element<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Element,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_element(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Namespace,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<swc_atoms::Atom>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<DocumentFragment>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Namespace>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_raw<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Raw>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_raw<'ast: 'r, 'r>(&mut self, node: &'ast Raw, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_common::Span,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_span(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_text<'ast: 'r, 'r>(&mut self, node: &'ast Text, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_text(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_token<'ast: 'r, 'r>(&mut self, node: &'ast Token, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_token_and_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast TokenAndSpan,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_token_and_span(&mut **self, node, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> VisitAstPath for Box<V>
where
    V: ?Sized + VisitAstPath,
{
    #[inline]
    fn visit_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_atoms::Atom,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attribute<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Attribute,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attribute_token<'ast: 'r, 'r>(
        &mut self,
        node: &'ast AttributeToken,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attribute_tokens<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [AttributeToken],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute_tokens(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_attributes<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Attribute],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attributes(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_child<'ast: 'r, 'r>(&mut self, node: &'ast Child, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_child(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_childs<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Child],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_childs(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_comment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Comment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_comment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Document,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentFragment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document_mode<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentMode,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_mode(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_document_type<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentType,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_type(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_element<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Element,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_element(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Namespace,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<swc_atoms::Atom>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<DocumentFragment>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Namespace>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_opt_raw<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Raw>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_raw<'ast: 'r, 'r>(&mut self, node: &'ast Raw, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_common::Span,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_span(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_text<'ast: 'r, 'r>(&mut self, node: &'ast Text, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_text(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_token<'ast: 'r, 'r>(&mut self, node: &'ast Token, __ast_path: &mut AstNodePath<'r>) {
        <V as VisitAstPath>::visit_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_token_and_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast TokenAndSpan,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_token_and_span(&mut **self, node, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<A, B> VisitAstPath for ::swc_visit::Either<A, B>
where
    A: VisitAstPath,
    B: VisitAstPath,
{
    #[inline]
    fn visit_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_atoms::Atom,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => VisitAstPath::visit_atom(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_atom(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_attribute<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Attribute,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_attribute(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_attribute(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_attribute_token<'ast: 'r, 'r>(
        &mut self,
        node: &'ast AttributeToken,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_attribute_token(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_attribute_token(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_attribute_tokens<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [AttributeToken],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_attribute_tokens(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_attribute_tokens(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_attributes<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Attribute],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_attributes(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_attributes(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_child<'ast: 'r, 'r>(&mut self, node: &'ast Child, __ast_path: &mut AstNodePath<'r>) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_child(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_child(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_childs<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Child],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_childs(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_childs(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_comment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Comment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_comment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_comment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_document<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Document,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_document(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_document(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentFragment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_document_fragment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_document_fragment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_document_mode<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentMode,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_document_mode(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_document_mode(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_document_type<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentType,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_document_type(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_document_type(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_element<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Element,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_element(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_element(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Namespace,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_namespace(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_namespace(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_opt_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<swc_atoms::Atom>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_opt_atom(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_opt_atom(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_opt_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<DocumentFragment>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_opt_document_fragment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_opt_document_fragment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_opt_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Namespace>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_opt_namespace(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_opt_namespace(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_opt_raw<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Raw>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_opt_raw(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_opt_raw(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_raw<'ast: 'r, 'r>(&mut self, node: &'ast Raw, __ast_path: &mut AstNodePath<'r>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitAstPath::visit_raw(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => VisitAstPath::visit_raw(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn visit_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_common::Span,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => VisitAstPath::visit_span(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_span(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_text<'ast: 'r, 'r>(&mut self, node: &'ast Text, __ast_path: &mut AstNodePath<'r>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitAstPath::visit_text(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_text(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_token<'ast: 'r, 'r>(&mut self, node: &'ast Token, __ast_path: &mut AstNodePath<'r>) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_token(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_token(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_token_and_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast TokenAndSpan,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitAstPath::visit_token_and_span(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitAstPath::visit_token_and_span(visitor, node, __ast_path)
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> VisitAstPath for ::swc_visit::Optional<V>
where
    V: VisitAstPath,
{
    #[inline]
    fn visit_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_atoms::Atom,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_atom(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_attribute<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Attribute,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_attribute(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_attribute_token<'ast: 'r, 'r>(
        &mut self,
        node: &'ast AttributeToken,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_attribute_token(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_attribute_tokens<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [AttributeToken],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_attribute_tokens(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_attributes<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Attribute],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_attributes(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_child<'ast: 'r, 'r>(&mut self, node: &'ast Child, __ast_path: &mut AstNodePath<'r>) {
        if self.enabled {
            <V as VisitAstPath>::visit_child(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_childs<'ast: 'r, 'r>(
        &mut self,
        node: &'ast [Child],
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_childs(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_comment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Comment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_comment(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_document<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Document,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_document(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentFragment,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_document_fragment(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_document_mode<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentMode,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_document_mode(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_document_type<'ast: 'r, 'r>(
        &mut self,
        node: &'ast DocumentType,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_document_type(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_element<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Element,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_element(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Namespace,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_namespace(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_opt_atom<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<swc_atoms::Atom>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_opt_atom(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_opt_document_fragment<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<DocumentFragment>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_opt_document_fragment(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_opt_namespace<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Namespace>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_opt_namespace(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_opt_raw<'ast: 'r, 'r>(
        &mut self,
        node: &'ast Option<Raw>,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_opt_raw(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_raw<'ast: 'r, 'r>(&mut self, node: &'ast Raw, __ast_path: &mut AstNodePath<'r>) {
        if self.enabled {
            <V as VisitAstPath>::visit_raw(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast swc_common::Span,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_span(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_text<'ast: 'r, 'r>(&mut self, node: &'ast Text, __ast_path: &mut AstNodePath<'r>) {
        if self.enabled {
            <V as VisitAstPath>::visit_text(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_token<'ast: 'r, 'r>(&mut self, node: &'ast Token, __ast_path: &mut AstNodePath<'r>) {
        if self.enabled {
            <V as VisitAstPath>::visit_token(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_token_and_span<'ast: 'r, 'r>(
        &mut self,
        node: &'ast TokenAndSpan,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        if self.enabled {
            <V as VisitAstPath>::visit_token_and_span(&mut self.visitor, node, __ast_path)
        } else {
        }
    }
}
#[doc = r" A trait implemented for types that can be visited using a visitor."]
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
pub trait VisitWithAstPath<V: ?Sized + VisitAstPath> {
    #[doc = r" Calls a visitor method (visitor.fold_xxx) with self."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    );
    #[doc = r" Visit children nodes of `self`` with `visitor`."]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    );
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Attribute {
    #[doc = "Calls [VisitAstPath`::visit_attribute`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Attribute {
                span,
                namespace,
                prefix,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::Namespace,
                    ));
                    <Option<Namespace> as VisitWithAstPath<V>>::visit_with_ast_path(
                        namespace,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::Prefix,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        prefix,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::Name,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::RawName,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::Value,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Attribute(
                        self,
                        self::fields::AttributeField::RawValue,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw_value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for AttributeToken {
    #[doc = "Calls [VisitAstPath`::visit_attribute_token`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute_token(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            AttributeToken {
                span,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::AttributeToken(
                        self,
                        self::fields::AttributeTokenField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::AttributeToken(
                        self,
                        self::fields::AttributeTokenField::Name,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::AttributeToken(
                        self,
                        self::fields::AttributeTokenField::RawName,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::AttributeToken(
                        self,
                        self::fields::AttributeTokenField::Value,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::AttributeToken(
                        self,
                        self::fields::AttributeTokenField::RawValue,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw_value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Child {
    #[doc = "Calls [VisitAstPath`::visit_child`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_child(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Child::DocumentType { 0: _field_0 } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Child(
                    self,
                    self::fields::ChildField::DocumentType,
                ));
                <DocumentType as VisitWithAstPath<V>>::visit_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
            Child::Element { 0: _field_0 } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Child(
                    self,
                    self::fields::ChildField::Element,
                ));
                <Element as VisitWithAstPath<V>>::visit_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
            Child::Text { 0: _field_0 } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Child(
                    self,
                    self::fields::ChildField::Text,
                ));
                <Text as VisitWithAstPath<V>>::visit_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
            Child::Comment { 0: _field_0 } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Child(
                    self,
                    self::fields::ChildField::Comment,
                ));
                <Comment as VisitWithAstPath<V>>::visit_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Comment {
    #[doc = "Calls [VisitAstPath`::visit_comment`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_comment(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Comment { span, data, raw } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Comment(
                        self,
                        self::fields::CommentField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Comment(
                        self,
                        self::fields::CommentField::Data,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Comment(
                        self,
                        self::fields::CommentField::Raw,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Document {
    #[doc = "Calls [VisitAstPath`::visit_document`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Document {
                span,
                mode,
                children,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Document(
                        self,
                        self::fields::DocumentField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Document(
                        self,
                        self::fields::DocumentField::Mode,
                    ));
                    <DocumentMode as VisitWithAstPath<V>>::visit_with_ast_path(
                        mode,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Document(
                        self,
                        self::fields::DocumentField::Children(usize::MAX),
                    ));
                    <Vec<Child> as VisitWithAstPath<V>>::visit_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for DocumentFragment {
    #[doc = "Calls [VisitAstPath`::visit_document_fragment`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_fragment(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            DocumentFragment { span, children } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentFragment(
                        self,
                        self::fields::DocumentFragmentField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentFragment(
                        self,
                        self::fields::DocumentFragmentField::Children(usize::MAX),
                    ));
                    <Vec<Child> as VisitWithAstPath<V>>::visit_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for DocumentMode {
    #[doc = "Calls [VisitAstPath`::visit_document_mode`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_mode(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            DocumentMode::NoQuirks => {}
            DocumentMode::LimitedQuirks => {}
            DocumentMode::Quirks => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for DocumentType {
    #[doc = "Calls [VisitAstPath`::visit_document_type`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_document_type(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            DocumentType {
                span,
                name,
                public_id,
                system_id,
                raw,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentType(
                        self,
                        self::fields::DocumentTypeField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentType(
                        self,
                        self::fields::DocumentTypeField::Name,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentType(
                        self,
                        self::fields::DocumentTypeField::PublicId,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        public_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentType(
                        self,
                        self::fields::DocumentTypeField::SystemId,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        system_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::DocumentType(
                        self,
                        self::fields::DocumentTypeField::Raw,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Element {
    #[doc = "Calls [VisitAstPath`::visit_element`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_element(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Element {
                span,
                tag_name,
                namespace,
                attributes,
                children,
                content,
                is_self_closing,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Element(
                        self,
                        self::fields::ElementField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Element(
                        self,
                        self::fields::ElementField::TagName,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Element(
                        self,
                        self::fields::ElementField::Namespace,
                    ));
                    <Namespace as VisitWithAstPath<V>>::visit_with_ast_path(
                        namespace,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Element(
                        self,
                        self::fields::ElementField::Attributes(usize::MAX),
                    ));
                    <Vec<Attribute> as VisitWithAstPath<V>>::visit_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Element(
                        self,
                        self::fields::ElementField::Children(usize::MAX),
                    ));
                    <Vec<Child> as VisitWithAstPath<V>>::visit_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Element(
                        self,
                        self::fields::ElementField::Content,
                    ));
                    <Option<DocumentFragment> as VisitWithAstPath<V>>::visit_with_ast_path(
                        content,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Namespace {
    #[doc = "Calls [VisitAstPath`::visit_namespace`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_namespace(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Namespace::HTML => {}
            Namespace::MATHML => {}
            Namespace::SVG => {}
            Namespace::XLINK => {}
            Namespace::XML => {}
            Namespace::XMLNS => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Raw {
    #[doc = "Calls [VisitAstPath`::visit_raw`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_raw(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Raw::Same => {}
            Raw::Atom { 0: _field_0 } => {
                let mut __ast_path = __ast_path
                    .with_guard(AstParentNodeRef::Raw(self, self::fields::RawField::Atom));
                <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Text {
    #[doc = "Calls [VisitAstPath`::visit_text`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_text(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Text { span, data, raw } => {
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentNodeRef::Text(self, self::fields::TextField::Span));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentNodeRef::Text(self, self::fields::TextField::Data));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentNodeRef::Text(self, self::fields::TextField::Raw));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Token {
    #[doc = "Calls [VisitAstPath`::visit_token`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_token(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Token::Doctype {
                name,
                force_quirks,
                public_id,
                system_id,
                raw,
            } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                    self,
                    self::fields::TokenField::Doctype,
                ));
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::Name,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::PublicId,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        public_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::SystemId,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        system_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentNodeRef::Token(self, self::fields::TokenField::Raw));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::StartTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                    self,
                    self::fields::TokenField::StartTag,
                ));
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::TagName,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::RawTagName,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw_tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::Attributes(usize::MAX),
                    ));
                    <Vec<AttributeToken> as VisitWithAstPath<V>>::visit_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::EndTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                    self,
                    self::fields::TokenField::EndTag,
                ));
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::TagName,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::RawTagName,
                    ));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw_tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::Attributes(usize::MAX),
                    ));
                    <Vec<AttributeToken> as VisitWithAstPath<V>>::visit_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::Comment { data, raw } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                    self,
                    self::fields::TokenField::Comment,
                ));
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                        self,
                        self::fields::TokenField::Data,
                    ));
                    <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentNodeRef::Token(self, self::fields::TokenField::Raw));
                    <Option<swc_atoms::Atom> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::Character { value, raw } => {
                let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::Token(
                    self,
                    self::fields::TokenField::Character,
                ));
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentNodeRef::Token(self, self::fields::TokenField::Raw));
                    <Option<Raw> as VisitWithAstPath<V>>::visit_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::Eof => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for TokenAndSpan {
    #[doc = "Calls [VisitAstPath`::visit_token_and_span`] with `self`."]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_token_and_span(visitor, self, __ast_path)
    }

    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            TokenAndSpan { span, token } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::TokenAndSpan(
                        self,
                        self::fields::TokenAndSpanField::Span,
                    ));
                    <swc_common::Span as VisitWithAstPath<V>>::visit_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentNodeRef::TokenAndSpan(
                        self,
                        self::fields::TokenAndSpanField::Token,
                    ));
                    <Token as VisitWithAstPath<V>>::visit_with_ast_path(
                        token,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for swc_atoms::Atom {
    #[doc = "Calls [VisitAstPath`::visit_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_atom(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        {}
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for [AttributeToken] {
    #[doc = "Calls [VisitAstPath`::visit_attribute_tokens`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attribute_tokens(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        self.iter().enumerate().for_each(|(__idx, item)| {
            let mut __ast_path = __ast_path.with_index_guard(__idx);
            <AttributeToken as VisitWithAstPath<V>>::visit_with_ast_path(
                item,
                visitor,
                &mut *__ast_path,
            )
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for [Attribute] {
    #[doc = "Calls [VisitAstPath`::visit_attributes`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_attributes(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        self.iter().enumerate().for_each(|(__idx, item)| {
            let mut __ast_path = __ast_path.with_index_guard(__idx);
            <Attribute as VisitWithAstPath<V>>::visit_with_ast_path(item, visitor, &mut *__ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for [Child] {
    #[doc = "Calls [VisitAstPath`::visit_childs`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_childs(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        self.iter().enumerate().for_each(|(__idx, item)| {
            let mut __ast_path = __ast_path.with_index_guard(__idx);
            <Child as VisitWithAstPath<V>>::visit_with_ast_path(item, visitor, &mut *__ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Option<swc_atoms::Atom> {
    #[doc = "Calls [VisitAstPath`::visit_opt_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_atom(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Some(inner) => <swc_atoms::Atom as VisitWithAstPath<V>>::visit_with_ast_path(
                inner, visitor, __ast_path,
            ),
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Option<DocumentFragment> {
    #[doc = "Calls [VisitAstPath`::visit_opt_document_fragment`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_document_fragment(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Some(inner) => <DocumentFragment as VisitWithAstPath<V>>::visit_with_ast_path(
                inner, visitor, __ast_path,
            ),
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Option<Namespace> {
    #[doc = "Calls [VisitAstPath`::visit_opt_namespace`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_namespace(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Some(inner) => {
                <Namespace as VisitWithAstPath<V>>::visit_with_ast_path(inner, visitor, __ast_path)
            }
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for Option<Raw> {
    #[doc = "Calls [VisitAstPath`::visit_opt_raw`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_opt_raw(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        match self {
            Some(inner) => {
                <Raw as VisitWithAstPath<V>>::visit_with_ast_path(inner, visitor, __ast_path)
            }
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitAstPath> VisitWithAstPath<V> for swc_common::Span {
    #[doc = "Calls [VisitAstPath`::visit_span`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        <V as VisitAstPath>::visit_span(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        {}
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V, T> VisitWithAstPath<V> for std::boxed::Box<T>
where
    V: ?Sized + VisitAstPath,
    T: VisitWithAstPath<V>,
{
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        let v = <T as VisitWithAstPath<V>>::visit_with_ast_path(&**self, visitor, __ast_path);
        v
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        let v =
            <T as VisitWithAstPath<V>>::visit_children_with_ast_path(&**self, visitor, __ast_path);
        v
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V, T> VisitWithAstPath<V> for std::vec::Vec<T>
where
    V: ?Sized + VisitAstPath,
    [T]: VisitWithAstPath<V>,
{
    #[inline]
    fn visit_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        let v = <[T] as VisitWithAstPath<V>>::visit_with_ast_path(self, visitor, __ast_path);
        v
    }

    #[inline]
    fn visit_children_with_ast_path<'ast: 'r, 'r>(
        &'ast self,
        visitor: &mut V,
        __ast_path: &mut AstNodePath<'r>,
    ) {
        let v =
            <[T] as VisitWithAstPath<V>>::visit_children_with_ast_path(self, visitor, __ast_path);
        v
    }
}
#[doc = r" A visitor trait for traversing the AST."]
pub trait VisitMut {
    #[doc = "Visit a node of type `swc_atoms :: Atom`.\n\nBy default, this method calls \
             [`swc_atoms :: Atom::visit_mut_children_with`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom) {
        <swc_atoms::Atom as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Attribute`.\n\nBy default, this method calls \
             [`Attribute::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute) {
        <Attribute as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `AttributeToken`.\n\nBy default, this method calls \
             [`AttributeToken::visit_mut_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_attribute_token(&mut self, node: &mut AttributeToken) {
        <AttributeToken as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < AttributeToken >`.\n\nBy default, this method calls [`Vec \
             < AttributeToken >::visit_mut_children_with`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_attribute_tokens(&mut self, node: &mut Vec<AttributeToken>) {
        <Vec<AttributeToken> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < Attribute >`.\n\nBy default, this method calls [`Vec < \
             Attribute >::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>) {
        <Vec<Attribute> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Child`.\n\nBy default, this method calls \
             [`Child::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child) {
        <Child as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < Child >`.\n\nBy default, this method calls [`Vec < Child \
             >::visit_mut_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>) {
        <Vec<Child> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Comment`.\n\nBy default, this method calls \
             [`Comment::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment) {
        <Comment as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Document`.\n\nBy default, this method calls \
             [`Document::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document) {
        <Document as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentFragment`.\n\nBy default, this method calls \
             [`DocumentFragment::visit_mut_children_with`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_document_fragment(&mut self, node: &mut DocumentFragment) {
        <DocumentFragment as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentMode`.\n\nBy default, this method calls \
             [`DocumentMode::visit_mut_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode) {
        <DocumentMode as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentType`.\n\nBy default, this method calls \
             [`DocumentType::visit_mut_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType) {
        <DocumentType as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Element`.\n\nBy default, this method calls \
             [`Element::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element) {
        <Element as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Namespace`.\n\nBy default, this method calls \
             [`Namespace::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace) {
        <Namespace as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < swc_atoms :: Atom >`.\n\nBy default, this method calls \
             [`Option < swc_atoms :: Atom >::visit_mut_children_with`]. If you want to recurse, \
             you need to call it manually."]
    #[inline]
    fn visit_mut_opt_atom(&mut self, node: &mut Option<swc_atoms::Atom>) {
        <Option<swc_atoms::Atom> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < DocumentFragment >`.\n\nBy default, this method calls \
             [`Option < DocumentFragment >::visit_mut_children_with`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_mut_opt_document_fragment(&mut self, node: &mut Option<DocumentFragment>) {
        <Option<DocumentFragment> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < Namespace >`.\n\nBy default, this method calls \
             [`Option < Namespace >::visit_mut_children_with`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_mut_opt_namespace(&mut self, node: &mut Option<Namespace>) {
        <Option<Namespace> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < Raw >`.\n\nBy default, this method calls [`Option < \
             Raw >::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>) {
        <Option<Raw> as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Raw`.\n\nBy default, this method calls \
             [`Raw::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw) {
        <Raw as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `swc_common :: Span`.\n\nBy default, this method calls \
             [`swc_common :: Span::visit_mut_children_with`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span) {
        <swc_common::Span as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Text`.\n\nBy default, this method calls \
             [`Text::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text) {
        <Text as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `Token`.\n\nBy default, this method calls \
             [`Token::visit_mut_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token) {
        <Token as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
    #[doc = "Visit a node of type `TokenAndSpan`.\n\nBy default, this method calls \
             [`TokenAndSpan::visit_mut_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan) {
        <TokenAndSpan as VisitMutWith<Self>>::visit_mut_children_with(node, self)
    }
}
impl<V> VisitMut for &mut V
where
    V: ?Sized + VisitMut,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom) {
        <V as VisitMut>::visit_mut_atom(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute) {
        <V as VisitMut>::visit_mut_attribute(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attribute_token(&mut self, node: &mut AttributeToken) {
        <V as VisitMut>::visit_mut_attribute_token(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attribute_tokens(&mut self, node: &mut Vec<AttributeToken>) {
        <V as VisitMut>::visit_mut_attribute_tokens(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>) {
        <V as VisitMut>::visit_mut_attributes(&mut **self, node)
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child) {
        <V as VisitMut>::visit_mut_child(&mut **self, node)
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>) {
        <V as VisitMut>::visit_mut_childs(&mut **self, node)
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment) {
        <V as VisitMut>::visit_mut_comment(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document) {
        <V as VisitMut>::visit_mut_document(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document_fragment(&mut self, node: &mut DocumentFragment) {
        <V as VisitMut>::visit_mut_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode) {
        <V as VisitMut>::visit_mut_document_mode(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType) {
        <V as VisitMut>::visit_mut_document_type(&mut **self, node)
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element) {
        <V as VisitMut>::visit_mut_element(&mut **self, node)
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace) {
        <V as VisitMut>::visit_mut_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_atom(&mut self, node: &mut Option<swc_atoms::Atom>) {
        <V as VisitMut>::visit_mut_opt_atom(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_document_fragment(&mut self, node: &mut Option<DocumentFragment>) {
        <V as VisitMut>::visit_mut_opt_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_namespace(&mut self, node: &mut Option<Namespace>) {
        <V as VisitMut>::visit_mut_opt_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>) {
        <V as VisitMut>::visit_mut_opt_raw(&mut **self, node)
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw) {
        <V as VisitMut>::visit_mut_raw(&mut **self, node)
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span) {
        <V as VisitMut>::visit_mut_span(&mut **self, node)
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text) {
        <V as VisitMut>::visit_mut_text(&mut **self, node)
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token) {
        <V as VisitMut>::visit_mut_token(&mut **self, node)
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan) {
        <V as VisitMut>::visit_mut_token_and_span(&mut **self, node)
    }
}
impl<V> VisitMut for Box<V>
where
    V: ?Sized + VisitMut,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom) {
        <V as VisitMut>::visit_mut_atom(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute) {
        <V as VisitMut>::visit_mut_attribute(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attribute_token(&mut self, node: &mut AttributeToken) {
        <V as VisitMut>::visit_mut_attribute_token(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attribute_tokens(&mut self, node: &mut Vec<AttributeToken>) {
        <V as VisitMut>::visit_mut_attribute_tokens(&mut **self, node)
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>) {
        <V as VisitMut>::visit_mut_attributes(&mut **self, node)
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child) {
        <V as VisitMut>::visit_mut_child(&mut **self, node)
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>) {
        <V as VisitMut>::visit_mut_childs(&mut **self, node)
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment) {
        <V as VisitMut>::visit_mut_comment(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document) {
        <V as VisitMut>::visit_mut_document(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document_fragment(&mut self, node: &mut DocumentFragment) {
        <V as VisitMut>::visit_mut_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode) {
        <V as VisitMut>::visit_mut_document_mode(&mut **self, node)
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType) {
        <V as VisitMut>::visit_mut_document_type(&mut **self, node)
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element) {
        <V as VisitMut>::visit_mut_element(&mut **self, node)
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace) {
        <V as VisitMut>::visit_mut_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_atom(&mut self, node: &mut Option<swc_atoms::Atom>) {
        <V as VisitMut>::visit_mut_opt_atom(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_document_fragment(&mut self, node: &mut Option<DocumentFragment>) {
        <V as VisitMut>::visit_mut_opt_document_fragment(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_namespace(&mut self, node: &mut Option<Namespace>) {
        <V as VisitMut>::visit_mut_opt_namespace(&mut **self, node)
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>) {
        <V as VisitMut>::visit_mut_opt_raw(&mut **self, node)
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw) {
        <V as VisitMut>::visit_mut_raw(&mut **self, node)
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span) {
        <V as VisitMut>::visit_mut_span(&mut **self, node)
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text) {
        <V as VisitMut>::visit_mut_text(&mut **self, node)
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token) {
        <V as VisitMut>::visit_mut_token(&mut **self, node)
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan) {
        <V as VisitMut>::visit_mut_token_and_span(&mut **self, node)
    }
}
impl<A, B> VisitMut for ::swc_visit::Either<A, B>
where
    A: VisitMut,
    B: VisitMut,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_atom(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_atom(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_attribute(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_attribute(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_attribute_token(&mut self, node: &mut AttributeToken) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_attribute_token(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_attribute_token(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_attribute_tokens(&mut self, node: &mut Vec<AttributeToken>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_attribute_tokens(visitor, node),
            swc_visit::Either::Right(visitor) => {
                VisitMut::visit_mut_attribute_tokens(visitor, node)
            }
        }
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_attributes(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_attributes(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_child(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_child(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_childs(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_childs(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_comment(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_comment(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_document(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_document(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_document_fragment(&mut self, node: &mut DocumentFragment) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMut::visit_mut_document_fragment(visitor, node)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMut::visit_mut_document_fragment(visitor, node)
            }
        }
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_document_mode(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_document_mode(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_document_type(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_document_type(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_element(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_element(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_namespace(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_namespace(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_opt_atom(&mut self, node: &mut Option<swc_atoms::Atom>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_opt_atom(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_opt_atom(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_opt_document_fragment(&mut self, node: &mut Option<DocumentFragment>) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMut::visit_mut_opt_document_fragment(visitor, node)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMut::visit_mut_opt_document_fragment(visitor, node)
            }
        }
    }

    #[inline]
    fn visit_mut_opt_namespace(&mut self, node: &mut Option<Namespace>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_opt_namespace(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_opt_namespace(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_opt_raw(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_opt_raw(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_raw(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_raw(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_span(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_span(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_text(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_text(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_token(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_token(visitor, node),
        }
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan) {
        match self {
            swc_visit::Either::Left(visitor) => VisitMut::visit_mut_token_and_span(visitor, node),
            swc_visit::Either::Right(visitor) => VisitMut::visit_mut_token_and_span(visitor, node),
        }
    }
}
impl<V> VisitMut for ::swc_visit::Optional<V>
where
    V: VisitMut,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom) {
        if self.enabled {
            <V as VisitMut>::visit_mut_atom(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute) {
        if self.enabled {
            <V as VisitMut>::visit_mut_attribute(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attribute_token(&mut self, node: &mut AttributeToken) {
        if self.enabled {
            <V as VisitMut>::visit_mut_attribute_token(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attribute_tokens(&mut self, node: &mut Vec<AttributeToken>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_attribute_tokens(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_attributes(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child) {
        if self.enabled {
            <V as VisitMut>::visit_mut_child(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_childs(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment) {
        if self.enabled {
            <V as VisitMut>::visit_mut_comment(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document) {
        if self.enabled {
            <V as VisitMut>::visit_mut_document(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document_fragment(&mut self, node: &mut DocumentFragment) {
        if self.enabled {
            <V as VisitMut>::visit_mut_document_fragment(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode) {
        if self.enabled {
            <V as VisitMut>::visit_mut_document_mode(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType) {
        if self.enabled {
            <V as VisitMut>::visit_mut_document_type(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element) {
        if self.enabled {
            <V as VisitMut>::visit_mut_element(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace) {
        if self.enabled {
            <V as VisitMut>::visit_mut_namespace(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_atom(&mut self, node: &mut Option<swc_atoms::Atom>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_opt_atom(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_document_fragment(&mut self, node: &mut Option<DocumentFragment>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_opt_document_fragment(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_namespace(&mut self, node: &mut Option<Namespace>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_opt_namespace(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>) {
        if self.enabled {
            <V as VisitMut>::visit_mut_opt_raw(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw) {
        if self.enabled {
            <V as VisitMut>::visit_mut_raw(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span) {
        if self.enabled {
            <V as VisitMut>::visit_mut_span(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text) {
        if self.enabled {
            <V as VisitMut>::visit_mut_text(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token) {
        if self.enabled {
            <V as VisitMut>::visit_mut_token(&mut self.visitor, node)
        } else {
        }
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan) {
        if self.enabled {
            <V as VisitMut>::visit_mut_token_and_span(&mut self.visitor, node)
        } else {
        }
    }
}
#[doc = r" A trait implemented for types that can be visited using a visitor."]
pub trait VisitMutWith<V: ?Sized + VisitMut> {
    #[doc = r" Calls a visitor method (visitor.fold_xxx) with self."]
    fn visit_mut_with(&mut self, visitor: &mut V);
    #[doc = r" Visit children nodes of `self`` with `visitor`."]
    fn visit_mut_children_with(&mut self, visitor: &mut V);
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Attribute {
    #[doc = "Calls [VisitMut`::visit_mut_attribute`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_attribute(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Attribute {
                span,
                namespace,
                prefix,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <Option<Namespace> as VisitMutWith<V>>::visit_mut_with(namespace, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(prefix, visitor)
                };
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(value, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw_value, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for AttributeToken {
    #[doc = "Calls [VisitMut`::visit_mut_attribute_token`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_attribute_token(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            AttributeToken {
                span,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(value, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw_value, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Child {
    #[doc = "Calls [VisitMut`::visit_mut_child`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_child(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Child::DocumentType { 0: _field_0 } => {
                <DocumentType as VisitMutWith<V>>::visit_mut_with(_field_0, visitor);
            }
            Child::Element { 0: _field_0 } => {
                <Element as VisitMutWith<V>>::visit_mut_with(_field_0, visitor);
            }
            Child::Text { 0: _field_0 } => {
                <Text as VisitMutWith<V>>::visit_mut_with(_field_0, visitor);
            }
            Child::Comment { 0: _field_0 } => {
                <Comment as VisitMutWith<V>>::visit_mut_with(_field_0, visitor);
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Comment {
    #[doc = "Calls [VisitMut`::visit_mut_comment`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_comment(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Comment { span, data, raw } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(data, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Document {
    #[doc = "Calls [VisitMut`::visit_mut_document`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_document(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Document {
                span,
                mode,
                children,
            } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <DocumentMode as VisitMutWith<V>>::visit_mut_with(mode, visitor)
                };
                {
                    <Vec<Child> as VisitMutWith<V>>::visit_mut_with(children, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for DocumentFragment {
    #[doc = "Calls [VisitMut`::visit_mut_document_fragment`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_document_fragment(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            DocumentFragment { span, children } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <Vec<Child> as VisitMutWith<V>>::visit_mut_with(children, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for DocumentMode {
    #[doc = "Calls [VisitMut`::visit_mut_document_mode`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_document_mode(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            DocumentMode::NoQuirks => {}
            DocumentMode::LimitedQuirks => {}
            DocumentMode::Quirks => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for DocumentType {
    #[doc = "Calls [VisitMut`::visit_mut_document_type`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_document_type(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            DocumentType {
                span,
                name,
                public_id,
                system_id,
                raw,
            } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(public_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(system_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Element {
    #[doc = "Calls [VisitMut`::visit_mut_element`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_element(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Element {
                span,
                tag_name,
                namespace,
                attributes,
                children,
                content,
                is_self_closing,
            } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(tag_name, visitor)
                };
                {
                    <Namespace as VisitMutWith<V>>::visit_mut_with(namespace, visitor)
                };
                {
                    <Vec<Attribute> as VisitMutWith<V>>::visit_mut_with(attributes, visitor)
                };
                {
                    <Vec<Child> as VisitMutWith<V>>::visit_mut_with(children, visitor)
                };
                {
                    <Option<DocumentFragment> as VisitMutWith<V>>::visit_mut_with(content, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Namespace {
    #[doc = "Calls [VisitMut`::visit_mut_namespace`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_namespace(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Namespace::HTML => {}
            Namespace::MATHML => {}
            Namespace::SVG => {}
            Namespace::XLINK => {}
            Namespace::XML => {}
            Namespace::XMLNS => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Raw {
    #[doc = "Calls [VisitMut`::visit_mut_raw`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_raw(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Raw::Same => {}
            Raw::Atom { 0: _field_0 } => {
                <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(_field_0, visitor);
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Text {
    #[doc = "Calls [VisitMut`::visit_mut_text`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_text(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Text { span, data, raw } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(data, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Token {
    #[doc = "Calls [VisitMut`::visit_mut_token`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_token(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Token::Doctype {
                name,
                force_quirks,
                public_id,
                system_id,
                raw,
            } => {
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(public_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(system_id, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw, visitor)
                };
            }
            Token::StartTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(tag_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(
                        raw_tag_name,
                        visitor,
                    )
                };
                {
                    <Vec<AttributeToken> as VisitMutWith<V>>::visit_mut_with(attributes, visitor)
                };
            }
            Token::EndTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(tag_name, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(
                        raw_tag_name,
                        visitor,
                    )
                };
                {
                    <Vec<AttributeToken> as VisitMutWith<V>>::visit_mut_with(attributes, visitor)
                };
            }
            Token::Comment { data, raw } => {
                {
                    <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(data, visitor)
                };
                {
                    <Option<swc_atoms::Atom> as VisitMutWith<V>>::visit_mut_with(raw, visitor)
                };
            }
            Token::Character { value, raw } => {
                {
                    <Option<Raw> as VisitMutWith<V>>::visit_mut_with(raw, visitor)
                };
            }
            Token::Eof => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for TokenAndSpan {
    #[doc = "Calls [VisitMut`::visit_mut_token_and_span`] with `self`."]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_token_and_span(visitor, self)
    }

    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            TokenAndSpan { span, token } => {
                {
                    <swc_common::Span as VisitMutWith<V>>::visit_mut_with(span, visitor)
                };
                {
                    <Token as VisitMutWith<V>>::visit_mut_with(token, visitor)
                };
            }
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for swc_atoms::Atom {
    #[doc = "Calls [VisitMut`::visit_mut_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_atom(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        {}
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Vec<AttributeToken> {
    #[doc = "Calls [VisitMut`::visit_mut_attribute_tokens`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_attribute_tokens(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        self.iter_mut()
            .for_each(|item| <AttributeToken as VisitMutWith<V>>::visit_mut_with(item, visitor))
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Vec<Attribute> {
    #[doc = "Calls [VisitMut`::visit_mut_attributes`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_attributes(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        self.iter_mut()
            .for_each(|item| <Attribute as VisitMutWith<V>>::visit_mut_with(item, visitor))
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Vec<Child> {
    #[doc = "Calls [VisitMut`::visit_mut_childs`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_childs(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        self.iter_mut()
            .for_each(|item| <Child as VisitMutWith<V>>::visit_mut_with(item, visitor))
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Option<swc_atoms::Atom> {
    #[doc = "Calls [VisitMut`::visit_mut_opt_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_opt_atom(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Some(inner) => <swc_atoms::Atom as VisitMutWith<V>>::visit_mut_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Option<DocumentFragment> {
    #[doc = "Calls [VisitMut`::visit_mut_opt_document_fragment`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_opt_document_fragment(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Some(inner) => <DocumentFragment as VisitMutWith<V>>::visit_mut_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Option<Namespace> {
    #[doc = "Calls [VisitMut`::visit_mut_opt_namespace`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_opt_namespace(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Some(inner) => <Namespace as VisitMutWith<V>>::visit_mut_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for Option<Raw> {
    #[doc = "Calls [VisitMut`::visit_mut_opt_raw`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_opt_raw(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        match self {
            Some(inner) => <Raw as VisitMutWith<V>>::visit_mut_with(inner, visitor),
            None => {}
        }
    }
}
impl<V: ?Sized + VisitMut> VisitMutWith<V> for swc_common::Span {
    #[doc = "Calls [VisitMut`::visit_mut_span`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        <V as VisitMut>::visit_mut_span(visitor, self)
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        {}
    }
}
impl<V, T> VisitMutWith<V> for std::boxed::Box<T>
where
    V: ?Sized + VisitMut,
    T: VisitMutWith<V>,
{
    #[inline]
    fn visit_mut_with(&mut self, visitor: &mut V) {
        let v = <T as VisitMutWith<V>>::visit_mut_with(&mut **self, visitor);
        v
    }

    #[inline]
    fn visit_mut_children_with(&mut self, visitor: &mut V) {
        let v = <T as VisitMutWith<V>>::visit_mut_children_with(&mut **self, visitor);
        v
    }
}
#[doc = r" A visitor trait for traversing the AST."]
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
pub trait VisitMutAstPath {
    #[doc = "Visit a node of type `swc_atoms :: Atom`.\n\nBy default, this method calls \
             [`swc_atoms :: Atom::visit_mut_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom, __ast_path: &mut AstKindPath) {
        <swc_atoms::Atom as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Attribute`.\n\nBy default, this method calls \
             [`Attribute::visit_mut_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute, __ast_path: &mut AstKindPath) {
        <Attribute as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `AttributeToken`.\n\nBy default, this method calls \
             [`AttributeToken::visit_mut_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_mut_attribute_token(
        &mut self,
        node: &mut AttributeToken,
        __ast_path: &mut AstKindPath,
    ) {
        <AttributeToken as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < AttributeToken >`.\n\nBy default, this method calls [`Vec \
             < AttributeToken >::visit_mut_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_mut_attribute_tokens(
        &mut self,
        node: &mut Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) {
        <Vec<AttributeToken> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < Attribute >`.\n\nBy default, this method calls [`Vec < \
             Attribute >::visit_mut_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>, __ast_path: &mut AstKindPath) {
        <Vec<Attribute> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Child`.\n\nBy default, this method calls \
             [`Child::visit_mut_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child, __ast_path: &mut AstKindPath) {
        <Child as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < Child >`.\n\nBy default, this method calls [`Vec < Child \
             >::visit_mut_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>, __ast_path: &mut AstKindPath) {
        <Vec<Child> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Comment`.\n\nBy default, this method calls \
             [`Comment::visit_mut_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment, __ast_path: &mut AstKindPath) {
        <Comment as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Document`.\n\nBy default, this method calls \
             [`Document::visit_mut_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document, __ast_path: &mut AstKindPath) {
        <Document as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `DocumentFragment`.\n\nBy default, this method calls \
             [`DocumentFragment::visit_mut_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_mut_document_fragment(
        &mut self,
        node: &mut DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) {
        <DocumentFragment as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `DocumentMode`.\n\nBy default, this method calls \
             [`DocumentMode::visit_mut_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode, __ast_path: &mut AstKindPath) {
        <DocumentMode as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `DocumentType`.\n\nBy default, this method calls \
             [`DocumentType::visit_mut_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType, __ast_path: &mut AstKindPath) {
        <DocumentType as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Element`.\n\nBy default, this method calls \
             [`Element::visit_mut_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element, __ast_path: &mut AstKindPath) {
        <Element as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Namespace`.\n\nBy default, this method calls \
             [`Namespace::visit_mut_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace, __ast_path: &mut AstKindPath) {
        <Namespace as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < swc_atoms :: Atom >`.\n\nBy default, this method calls \
             [`Option < swc_atoms :: Atom >::visit_mut_children_with_ast_path`]. If you want to \
             recurse, you need to call it manually."]
    #[inline]
    fn visit_mut_opt_atom(
        &mut self,
        node: &mut Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) {
        <Option<swc_atoms::Atom> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < DocumentFragment >`.\n\nBy default, this method calls \
             [`Option < DocumentFragment >::visit_mut_children_with_ast_path`]. If you want to \
             recurse, you need to call it manually."]
    #[inline]
    fn visit_mut_opt_document_fragment(
        &mut self,
        node: &mut Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) {
        <Option<DocumentFragment> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < Namespace >`.\n\nBy default, this method calls \
             [`Option < Namespace >::visit_mut_children_with_ast_path`]. If you want to recurse, \
             you need to call it manually."]
    #[inline]
    fn visit_mut_opt_namespace(
        &mut self,
        node: &mut Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) {
        <Option<Namespace> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < Raw >`.\n\nBy default, this method calls [`Option < \
             Raw >::visit_mut_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>, __ast_path: &mut AstKindPath) {
        <Option<Raw> as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Raw`.\n\nBy default, this method calls \
             [`Raw::visit_mut_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw, __ast_path: &mut AstKindPath) {
        <Raw as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `swc_common :: Span`.\n\nBy default, this method calls \
             [`swc_common :: Span::visit_mut_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span, __ast_path: &mut AstKindPath) {
        <swc_common::Span as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Text`.\n\nBy default, this method calls \
             [`Text::visit_mut_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text, __ast_path: &mut AstKindPath) {
        <Text as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Token`.\n\nBy default, this method calls \
             [`Token::visit_mut_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token, __ast_path: &mut AstKindPath) {
        <Token as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `TokenAndSpan`.\n\nBy default, this method calls \
             [`TokenAndSpan::visit_mut_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan, __ast_path: &mut AstKindPath) {
        <TokenAndSpan as VisitMutWithAstPath<Self>>::visit_mut_children_with_ast_path(
            node, self, __ast_path,
        )
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> VisitMutAstPath for &mut V
where
    V: ?Sized + VisitMutAstPath,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attribute(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attribute_token(
        &mut self,
        node: &mut AttributeToken,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_attribute_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attribute_tokens(
        &mut self,
        node: &mut Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_attribute_tokens(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attributes(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_child(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_childs(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_comment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document_fragment(
        &mut self,
        node: &mut DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_mode(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_type(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_element(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_atom(
        &mut self,
        node: &mut Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_opt_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_document_fragment(
        &mut self,
        node: &mut Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_opt_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_namespace(
        &mut self,
        node: &mut Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_opt_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_opt_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_span(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_text(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_token_and_span(&mut **self, node, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> VisitMutAstPath for Box<V>
where
    V: ?Sized + VisitMutAstPath,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attribute(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attribute_token(
        &mut self,
        node: &mut AttributeToken,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_attribute_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attribute_tokens(
        &mut self,
        node: &mut Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_attribute_tokens(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attributes(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_child(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_childs(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_comment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document_fragment(
        &mut self,
        node: &mut DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_mode(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_type(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_element(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_atom(
        &mut self,
        node: &mut Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_opt_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_document_fragment(
        &mut self,
        node: &mut Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_opt_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_namespace(
        &mut self,
        node: &mut Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) {
        <V as VisitMutAstPath>::visit_mut_opt_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_opt_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_span(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_text(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_token_and_span(&mut **self, node, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<A, B> VisitMutAstPath for ::swc_visit::Either<A, B>
where
    A: VisitMutAstPath,
    B: VisitMutAstPath,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_atom(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_atom(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_attribute(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_attribute(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_attribute_token(
        &mut self,
        node: &mut AttributeToken,
        __ast_path: &mut AstKindPath,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_attribute_token(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_attribute_token(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_attribute_tokens(
        &mut self,
        node: &mut Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_attribute_tokens(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_attribute_tokens(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_attributes(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_attributes(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_child(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_child(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_childs(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_childs(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_comment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_comment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_document(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_document(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_document_fragment(
        &mut self,
        node: &mut DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_document_fragment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_document_fragment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_document_mode(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_document_mode(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_document_type(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_document_type(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_element(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_element(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_namespace(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_namespace(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_opt_atom(
        &mut self,
        node: &mut Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_opt_atom(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_opt_atom(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_opt_document_fragment(
        &mut self,
        node: &mut Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_opt_document_fragment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_opt_document_fragment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_opt_namespace(
        &mut self,
        node: &mut Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_opt_namespace(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_opt_namespace(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_opt_raw(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_opt_raw(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_raw(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_raw(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_span(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_span(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_text(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_text(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_token(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_token(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan, __ast_path: &mut AstKindPath) {
        match self {
            swc_visit::Either::Left(visitor) => {
                VisitMutAstPath::visit_mut_token_and_span(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                VisitMutAstPath::visit_mut_token_and_span(visitor, node, __ast_path)
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> VisitMutAstPath for ::swc_visit::Optional<V>
where
    V: VisitMutAstPath,
{
    #[inline]
    fn visit_mut_atom(&mut self, node: &mut swc_atoms::Atom, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_atom(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attribute(&mut self, node: &mut Attribute, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_attribute(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attribute_token(
        &mut self,
        node: &mut AttributeToken,
        __ast_path: &mut AstKindPath,
    ) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_attribute_token(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attribute_tokens(
        &mut self,
        node: &mut Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_attribute_tokens(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_attributes(&mut self, node: &mut Vec<Attribute>, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_attributes(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_child(&mut self, node: &mut Child, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_child(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_childs(&mut self, node: &mut Vec<Child>, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_childs(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_comment(&mut self, node: &mut Comment, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_comment(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document(&mut self, node: &mut Document, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_document(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document_fragment(
        &mut self,
        node: &mut DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_document_fragment(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document_mode(&mut self, node: &mut DocumentMode, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_document_mode(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_document_type(&mut self, node: &mut DocumentType, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_document_type(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_element(&mut self, node: &mut Element, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_element(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_namespace(&mut self, node: &mut Namespace, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_namespace(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_atom(
        &mut self,
        node: &mut Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_opt_atom(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_document_fragment(
        &mut self,
        node: &mut Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_opt_document_fragment(
                &mut self.visitor,
                node,
                __ast_path,
            )
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_namespace(
        &mut self,
        node: &mut Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_opt_namespace(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_opt_raw(&mut self, node: &mut Option<Raw>, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_opt_raw(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_raw(&mut self, node: &mut Raw, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_raw(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_span(&mut self, node: &mut swc_common::Span, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_span(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_text(&mut self, node: &mut Text, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_text(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_token(&mut self, node: &mut Token, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_token(&mut self.visitor, node, __ast_path)
        } else {
        }
    }

    #[inline]
    fn visit_mut_token_and_span(&mut self, node: &mut TokenAndSpan, __ast_path: &mut AstKindPath) {
        if self.enabled {
            <V as VisitMutAstPath>::visit_mut_token_and_span(&mut self.visitor, node, __ast_path)
        } else {
        }
    }
}
#[doc = r" A trait implemented for types that can be visited using a visitor."]
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
pub trait VisitMutWithAstPath<V: ?Sized + VisitMutAstPath> {
    #[doc = r" Calls a visitor method (visitor.fold_xxx) with self."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath);
    #[doc = r" Visit children nodes of `self`` with `visitor`."]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath);
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Attribute {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_attribute`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attribute(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Attribute {
                span,
                namespace,
                prefix,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Attribute(self::fields::AttributeField::Span));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::Namespace,
                    ));
                    <Option<Namespace> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        namespace,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::Prefix,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        prefix,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Attribute(self::fields::AttributeField::Name));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::RawName,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::Value,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::RawValue,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw_value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for AttributeToken {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_attribute_token`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attribute_token(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            AttributeToken {
                span,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::Span,
                    ));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::Name,
                    ));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::RawName,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::Value,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::RawValue,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw_value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Child {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_child`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_child(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Child::DocumentType { 0: _field_0 } => {
                let mut __ast_path = __ast_path
                    .with_guard(AstParentKind::Child(self::fields::ChildField::DocumentType));
                <DocumentType as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
            Child::Element { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Child(self::fields::ChildField::Element));
                <Element as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
            Child::Text { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Child(self::fields::ChildField::Text));
                <Text as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
            Child::Comment { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Child(self::fields::ChildField::Comment));
                <Comment as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Comment {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_comment`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_comment(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Comment { span, data, raw } => {
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Comment(self::fields::CommentField::Span));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Comment(self::fields::CommentField::Data));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Comment(self::fields::CommentField::Raw));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Document {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_document`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Document {
                span,
                mode,
                children,
            } => {
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Document(self::fields::DocumentField::Span));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Document(self::fields::DocumentField::Mode));
                    <DocumentMode as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        mode,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Document(
                        self::fields::DocumentField::Children(usize::MAX),
                    ));
                    <Vec<Child> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for DocumentFragment {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_document_fragment`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_fragment(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            DocumentFragment { span, children } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentFragment(
                        self::fields::DocumentFragmentField::Span,
                    ));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentFragment(
                        self::fields::DocumentFragmentField::Children(usize::MAX),
                    ));
                    <Vec<Child> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for DocumentMode {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_document_mode`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_mode(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            DocumentMode::NoQuirks => {}
            DocumentMode::LimitedQuirks => {}
            DocumentMode::Quirks => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for DocumentType {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_document_type`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_document_type(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            DocumentType {
                span,
                name,
                public_id,
                system_id,
                raw,
            } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::Span,
                    ));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::Name,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::PublicId,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        public_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::SystemId,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        system_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::Raw,
                    ));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Element {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_element`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_element(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Element {
                span,
                tag_name,
                namespace,
                attributes,
                children,
                content,
                is_self_closing,
            } => {
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Element(self::fields::ElementField::Span));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Element(self::fields::ElementField::TagName));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Element(
                        self::fields::ElementField::Namespace,
                    ));
                    <Namespace as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        namespace,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Element(
                        self::fields::ElementField::Attributes(usize::MAX),
                    ));
                    <Vec<Attribute> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Element(
                        self::fields::ElementField::Children(usize::MAX),
                    ));
                    <Vec<Child> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Element(self::fields::ElementField::Content));
                    <Option<DocumentFragment> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        content,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Namespace {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_namespace`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_namespace(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Namespace::HTML => {}
            Namespace::MATHML => {}
            Namespace::SVG => {}
            Namespace::XLINK => {}
            Namespace::XML => {}
            Namespace::XMLNS => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Raw {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_raw`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_raw(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Raw::Same => {}
            Raw::Atom { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Raw(self::fields::RawField::Atom));
                <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Text {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_text`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_text(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Text { span, data, raw } => {
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Text(self::fields::TextField::Span));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Text(self::fields::TextField::Data));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Text(self::fields::TextField::Raw));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Token {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_token`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_token(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Token::Doctype {
                name,
                force_quirks,
                public_id,
                system_id,
                raw,
            } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Doctype));
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Name));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::PublicId));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        public_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::SystemId));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        system_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Raw));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::StartTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::StartTag));
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::TagName));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::RawTagName));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw_tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Token(
                        self::fields::TokenField::Attributes(usize::MAX),
                    ));
                    <Vec<AttributeToken> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::EndTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::EndTag));
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::TagName));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::RawTagName));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw_tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Token(
                        self::fields::TokenField::Attributes(usize::MAX),
                    ));
                    <Vec<AttributeToken> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::Comment { data, raw } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Comment));
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Data));
                    <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Raw));
                    <Option<swc_atoms::Atom> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::Character { value, raw } => {
                let mut __ast_path = __ast_path
                    .with_guard(AstParentKind::Token(self::fields::TokenField::Character));
                {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Raw));
                    <Option<Raw> as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
            Token::Eof => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for TokenAndSpan {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_token_and_span`] with `self`."]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_token_and_span(visitor, self, __ast_path)
    }

    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            TokenAndSpan { span, token } => {
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::TokenAndSpan(
                        self::fields::TokenAndSpanField::Span,
                    ));
                    <swc_common::Span as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::TokenAndSpan(
                        self::fields::TokenAndSpanField::Token,
                    ));
                    <Token as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                        token,
                        visitor,
                        &mut *__ast_path,
                    )
                };
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for swc_atoms::Atom {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_atom(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        {}
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Vec<AttributeToken> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_attribute_tokens`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attribute_tokens(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        self.iter_mut().enumerate().for_each(|(__idx, item)| {
            let mut __ast_path = __ast_path.with_index_guard(__idx);
            <AttributeToken as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                item,
                visitor,
                &mut *__ast_path,
            )
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Vec<Attribute> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_attributes`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_attributes(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        self.iter_mut().enumerate().for_each(|(__idx, item)| {
            let mut __ast_path = __ast_path.with_index_guard(__idx);
            <Attribute as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                item,
                visitor,
                &mut *__ast_path,
            )
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Vec<Child> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_childs`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_childs(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        self.iter_mut().enumerate().for_each(|(__idx, item)| {
            let mut __ast_path = __ast_path.with_index_guard(__idx);
            <Child as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                item,
                visitor,
                &mut *__ast_path,
            )
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Option<swc_atoms::Atom> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_opt_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_opt_atom(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Some(inner) => <swc_atoms::Atom as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                inner, visitor, __ast_path,
            ),
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Option<DocumentFragment> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_opt_document_fragment`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_opt_document_fragment(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Some(inner) => <DocumentFragment as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                inner, visitor, __ast_path,
            ),
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Option<Namespace> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_opt_namespace`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_opt_namespace(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Some(inner) => <Namespace as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
                inner, visitor, __ast_path,
            ),
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for Option<Raw> {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_opt_raw`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_opt_raw(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        match self {
            Some(inner) => {
                <Raw as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(inner, visitor, __ast_path)
            }
            None => {}
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + VisitMutAstPath> VisitMutWithAstPath<V> for swc_common::Span {
    #[doc = "Calls [VisitMutAstPath`::visit_mut_span`] with `self`. (Extra impl)"]
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        <V as VisitMutAstPath>::visit_mut_span(visitor, self, __ast_path)
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        {}
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V, T> VisitMutWithAstPath<V> for std::boxed::Box<T>
where
    V: ?Sized + VisitMutAstPath,
    T: VisitMutWithAstPath<V>,
{
    #[inline]
    fn visit_mut_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        let v = <T as VisitMutWithAstPath<V>>::visit_mut_with_ast_path(
            &mut **self,
            visitor,
            __ast_path,
        );
        v
    }

    #[inline]
    fn visit_mut_children_with_ast_path(&mut self, visitor: &mut V, __ast_path: &mut AstKindPath) {
        let v = <T as VisitMutWithAstPath<V>>::visit_mut_children_with_ast_path(
            &mut **self,
            visitor,
            __ast_path,
        );
        v
    }
}
#[doc = r" A visitor trait for traversing the AST."]
pub trait Fold {
    #[doc = "Visit a node of type `swc_atoms :: Atom`.\n\nBy default, this method calls \
             [`swc_atoms :: Atom::fold_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn fold_atom(&mut self, node: swc_atoms::Atom) -> swc_atoms::Atom {
        <swc_atoms::Atom as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Attribute`.\n\nBy default, this method calls \
             [`Attribute::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_attribute(&mut self, node: Attribute) -> Attribute {
        <Attribute as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `AttributeToken`.\n\nBy default, this method calls \
             [`AttributeToken::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_attribute_token(&mut self, node: AttributeToken) -> AttributeToken {
        <AttributeToken as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < AttributeToken >`.\n\nBy default, this method calls [`Vec \
             < AttributeToken >::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_attribute_tokens(&mut self, node: Vec<AttributeToken>) -> Vec<AttributeToken> {
        <Vec<AttributeToken> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < Attribute >`.\n\nBy default, this method calls [`Vec < \
             Attribute >::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_attributes(&mut self, node: Vec<Attribute>) -> Vec<Attribute> {
        <Vec<Attribute> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Child`.\n\nBy default, this method calls \
             [`Child::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_child(&mut self, node: Child) -> Child {
        <Child as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Vec < Child >`.\n\nBy default, this method calls [`Vec < Child \
             >::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>) -> Vec<Child> {
        <Vec<Child> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Comment`.\n\nBy default, this method calls \
             [`Comment::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_comment(&mut self, node: Comment) -> Comment {
        <Comment as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Document`.\n\nBy default, this method calls \
             [`Document::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_document(&mut self, node: Document) -> Document {
        <Document as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentFragment`.\n\nBy default, this method calls \
             [`DocumentFragment::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_document_fragment(&mut self, node: DocumentFragment) -> DocumentFragment {
        <DocumentFragment as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentMode`.\n\nBy default, this method calls \
             [`DocumentMode::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_document_mode(&mut self, node: DocumentMode) -> DocumentMode {
        <DocumentMode as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `DocumentType`.\n\nBy default, this method calls \
             [`DocumentType::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_document_type(&mut self, node: DocumentType) -> DocumentType {
        <DocumentType as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Element`.\n\nBy default, this method calls \
             [`Element::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_element(&mut self, node: Element) -> Element {
        <Element as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Namespace`.\n\nBy default, this method calls \
             [`Namespace::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_namespace(&mut self, node: Namespace) -> Namespace {
        <Namespace as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < swc_atoms :: Atom >`.\n\nBy default, this method calls \
             [`Option < swc_atoms :: Atom >::fold_children_with`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn fold_opt_atom(&mut self, node: Option<swc_atoms::Atom>) -> Option<swc_atoms::Atom> {
        <Option<swc_atoms::Atom> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < DocumentFragment >`.\n\nBy default, this method calls \
             [`Option < DocumentFragment >::fold_children_with`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
    ) -> Option<DocumentFragment> {
        <Option<DocumentFragment> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < Namespace >`.\n\nBy default, this method calls \
             [`Option < Namespace >::fold_children_with`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn fold_opt_namespace(&mut self, node: Option<Namespace>) -> Option<Namespace> {
        <Option<Namespace> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Option < Raw >`.\n\nBy default, this method calls [`Option < \
             Raw >::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>) -> Option<Raw> {
        <Option<Raw> as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Raw`.\n\nBy default, this method calls \
             [`Raw::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_raw(&mut self, node: Raw) -> Raw {
        <Raw as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `swc_common :: Span`.\n\nBy default, this method calls \
             [`swc_common :: Span::fold_children_with`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn fold_span(&mut self, node: swc_common::Span) -> swc_common::Span {
        <swc_common::Span as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Text`.\n\nBy default, this method calls \
             [`Text::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_text(&mut self, node: Text) -> Text {
        <Text as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `Token`.\n\nBy default, this method calls \
             [`Token::fold_children_with`]. If you want to recurse, you need to call it manually."]
    #[inline]
    fn fold_token(&mut self, node: Token) -> Token {
        <Token as FoldWith<Self>>::fold_children_with(node, self)
    }
    #[doc = "Visit a node of type `TokenAndSpan`.\n\nBy default, this method calls \
             [`TokenAndSpan::fold_children_with`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_token_and_span(&mut self, node: TokenAndSpan) -> TokenAndSpan {
        <TokenAndSpan as FoldWith<Self>>::fold_children_with(node, self)
    }
}
impl<V> Fold for &mut V
where
    V: ?Sized + Fold,
{
    #[inline]
    fn fold_atom(&mut self, node: swc_atoms::Atom) -> swc_atoms::Atom {
        <V as Fold>::fold_atom(&mut **self, node)
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute) -> Attribute {
        <V as Fold>::fold_attribute(&mut **self, node)
    }

    #[inline]
    fn fold_attribute_token(&mut self, node: AttributeToken) -> AttributeToken {
        <V as Fold>::fold_attribute_token(&mut **self, node)
    }

    #[inline]
    fn fold_attribute_tokens(&mut self, node: Vec<AttributeToken>) -> Vec<AttributeToken> {
        <V as Fold>::fold_attribute_tokens(&mut **self, node)
    }

    #[inline]
    fn fold_attributes(&mut self, node: Vec<Attribute>) -> Vec<Attribute> {
        <V as Fold>::fold_attributes(&mut **self, node)
    }

    #[inline]
    fn fold_child(&mut self, node: Child) -> Child {
        <V as Fold>::fold_child(&mut **self, node)
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>) -> Vec<Child> {
        <V as Fold>::fold_childs(&mut **self, node)
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment) -> Comment {
        <V as Fold>::fold_comment(&mut **self, node)
    }

    #[inline]
    fn fold_document(&mut self, node: Document) -> Document {
        <V as Fold>::fold_document(&mut **self, node)
    }

    #[inline]
    fn fold_document_fragment(&mut self, node: DocumentFragment) -> DocumentFragment {
        <V as Fold>::fold_document_fragment(&mut **self, node)
    }

    #[inline]
    fn fold_document_mode(&mut self, node: DocumentMode) -> DocumentMode {
        <V as Fold>::fold_document_mode(&mut **self, node)
    }

    #[inline]
    fn fold_document_type(&mut self, node: DocumentType) -> DocumentType {
        <V as Fold>::fold_document_type(&mut **self, node)
    }

    #[inline]
    fn fold_element(&mut self, node: Element) -> Element {
        <V as Fold>::fold_element(&mut **self, node)
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace) -> Namespace {
        <V as Fold>::fold_namespace(&mut **self, node)
    }

    #[inline]
    fn fold_opt_atom(&mut self, node: Option<swc_atoms::Atom>) -> Option<swc_atoms::Atom> {
        <V as Fold>::fold_opt_atom(&mut **self, node)
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
    ) -> Option<DocumentFragment> {
        <V as Fold>::fold_opt_document_fragment(&mut **self, node)
    }

    #[inline]
    fn fold_opt_namespace(&mut self, node: Option<Namespace>) -> Option<Namespace> {
        <V as Fold>::fold_opt_namespace(&mut **self, node)
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>) -> Option<Raw> {
        <V as Fold>::fold_opt_raw(&mut **self, node)
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw) -> Raw {
        <V as Fold>::fold_raw(&mut **self, node)
    }

    #[inline]
    fn fold_span(&mut self, node: swc_common::Span) -> swc_common::Span {
        <V as Fold>::fold_span(&mut **self, node)
    }

    #[inline]
    fn fold_text(&mut self, node: Text) -> Text {
        <V as Fold>::fold_text(&mut **self, node)
    }

    #[inline]
    fn fold_token(&mut self, node: Token) -> Token {
        <V as Fold>::fold_token(&mut **self, node)
    }

    #[inline]
    fn fold_token_and_span(&mut self, node: TokenAndSpan) -> TokenAndSpan {
        <V as Fold>::fold_token_and_span(&mut **self, node)
    }
}
impl<V> Fold for Box<V>
where
    V: ?Sized + Fold,
{
    #[inline]
    fn fold_atom(&mut self, node: swc_atoms::Atom) -> swc_atoms::Atom {
        <V as Fold>::fold_atom(&mut **self, node)
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute) -> Attribute {
        <V as Fold>::fold_attribute(&mut **self, node)
    }

    #[inline]
    fn fold_attribute_token(&mut self, node: AttributeToken) -> AttributeToken {
        <V as Fold>::fold_attribute_token(&mut **self, node)
    }

    #[inline]
    fn fold_attribute_tokens(&mut self, node: Vec<AttributeToken>) -> Vec<AttributeToken> {
        <V as Fold>::fold_attribute_tokens(&mut **self, node)
    }

    #[inline]
    fn fold_attributes(&mut self, node: Vec<Attribute>) -> Vec<Attribute> {
        <V as Fold>::fold_attributes(&mut **self, node)
    }

    #[inline]
    fn fold_child(&mut self, node: Child) -> Child {
        <V as Fold>::fold_child(&mut **self, node)
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>) -> Vec<Child> {
        <V as Fold>::fold_childs(&mut **self, node)
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment) -> Comment {
        <V as Fold>::fold_comment(&mut **self, node)
    }

    #[inline]
    fn fold_document(&mut self, node: Document) -> Document {
        <V as Fold>::fold_document(&mut **self, node)
    }

    #[inline]
    fn fold_document_fragment(&mut self, node: DocumentFragment) -> DocumentFragment {
        <V as Fold>::fold_document_fragment(&mut **self, node)
    }

    #[inline]
    fn fold_document_mode(&mut self, node: DocumentMode) -> DocumentMode {
        <V as Fold>::fold_document_mode(&mut **self, node)
    }

    #[inline]
    fn fold_document_type(&mut self, node: DocumentType) -> DocumentType {
        <V as Fold>::fold_document_type(&mut **self, node)
    }

    #[inline]
    fn fold_element(&mut self, node: Element) -> Element {
        <V as Fold>::fold_element(&mut **self, node)
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace) -> Namespace {
        <V as Fold>::fold_namespace(&mut **self, node)
    }

    #[inline]
    fn fold_opt_atom(&mut self, node: Option<swc_atoms::Atom>) -> Option<swc_atoms::Atom> {
        <V as Fold>::fold_opt_atom(&mut **self, node)
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
    ) -> Option<DocumentFragment> {
        <V as Fold>::fold_opt_document_fragment(&mut **self, node)
    }

    #[inline]
    fn fold_opt_namespace(&mut self, node: Option<Namespace>) -> Option<Namespace> {
        <V as Fold>::fold_opt_namespace(&mut **self, node)
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>) -> Option<Raw> {
        <V as Fold>::fold_opt_raw(&mut **self, node)
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw) -> Raw {
        <V as Fold>::fold_raw(&mut **self, node)
    }

    #[inline]
    fn fold_span(&mut self, node: swc_common::Span) -> swc_common::Span {
        <V as Fold>::fold_span(&mut **self, node)
    }

    #[inline]
    fn fold_text(&mut self, node: Text) -> Text {
        <V as Fold>::fold_text(&mut **self, node)
    }

    #[inline]
    fn fold_token(&mut self, node: Token) -> Token {
        <V as Fold>::fold_token(&mut **self, node)
    }

    #[inline]
    fn fold_token_and_span(&mut self, node: TokenAndSpan) -> TokenAndSpan {
        <V as Fold>::fold_token_and_span(&mut **self, node)
    }
}
impl<A, B> Fold for ::swc_visit::Either<A, B>
where
    A: Fold,
    B: Fold,
{
    #[inline]
    fn fold_atom(&mut self, node: swc_atoms::Atom) -> swc_atoms::Atom {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_atom(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_atom(visitor, node),
        }
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute) -> Attribute {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_attribute(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_attribute(visitor, node),
        }
    }

    #[inline]
    fn fold_attribute_token(&mut self, node: AttributeToken) -> AttributeToken {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_attribute_token(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_attribute_token(visitor, node),
        }
    }

    #[inline]
    fn fold_attribute_tokens(&mut self, node: Vec<AttributeToken>) -> Vec<AttributeToken> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_attribute_tokens(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_attribute_tokens(visitor, node),
        }
    }

    #[inline]
    fn fold_attributes(&mut self, node: Vec<Attribute>) -> Vec<Attribute> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_attributes(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_attributes(visitor, node),
        }
    }

    #[inline]
    fn fold_child(&mut self, node: Child) -> Child {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_child(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_child(visitor, node),
        }
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>) -> Vec<Child> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_childs(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_childs(visitor, node),
        }
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment) -> Comment {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_comment(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_comment(visitor, node),
        }
    }

    #[inline]
    fn fold_document(&mut self, node: Document) -> Document {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_document(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_document(visitor, node),
        }
    }

    #[inline]
    fn fold_document_fragment(&mut self, node: DocumentFragment) -> DocumentFragment {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_document_fragment(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_document_fragment(visitor, node),
        }
    }

    #[inline]
    fn fold_document_mode(&mut self, node: DocumentMode) -> DocumentMode {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_document_mode(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_document_mode(visitor, node),
        }
    }

    #[inline]
    fn fold_document_type(&mut self, node: DocumentType) -> DocumentType {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_document_type(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_document_type(visitor, node),
        }
    }

    #[inline]
    fn fold_element(&mut self, node: Element) -> Element {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_element(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_element(visitor, node),
        }
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace) -> Namespace {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_namespace(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_namespace(visitor, node),
        }
    }

    #[inline]
    fn fold_opt_atom(&mut self, node: Option<swc_atoms::Atom>) -> Option<swc_atoms::Atom> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_opt_atom(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_opt_atom(visitor, node),
        }
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
    ) -> Option<DocumentFragment> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_opt_document_fragment(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_opt_document_fragment(visitor, node),
        }
    }

    #[inline]
    fn fold_opt_namespace(&mut self, node: Option<Namespace>) -> Option<Namespace> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_opt_namespace(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_opt_namespace(visitor, node),
        }
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>) -> Option<Raw> {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_opt_raw(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_opt_raw(visitor, node),
        }
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw) -> Raw {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_raw(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_raw(visitor, node),
        }
    }

    #[inline]
    fn fold_span(&mut self, node: swc_common::Span) -> swc_common::Span {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_span(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_span(visitor, node),
        }
    }

    #[inline]
    fn fold_text(&mut self, node: Text) -> Text {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_text(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_text(visitor, node),
        }
    }

    #[inline]
    fn fold_token(&mut self, node: Token) -> Token {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_token(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_token(visitor, node),
        }
    }

    #[inline]
    fn fold_token_and_span(&mut self, node: TokenAndSpan) -> TokenAndSpan {
        match self {
            swc_visit::Either::Left(visitor) => Fold::fold_token_and_span(visitor, node),
            swc_visit::Either::Right(visitor) => Fold::fold_token_and_span(visitor, node),
        }
    }
}
impl<V> Fold for ::swc_visit::Optional<V>
where
    V: Fold,
{
    #[inline]
    fn fold_atom(&mut self, node: swc_atoms::Atom) -> swc_atoms::Atom {
        if self.enabled {
            <V as Fold>::fold_atom(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute) -> Attribute {
        if self.enabled {
            <V as Fold>::fold_attribute(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attribute_token(&mut self, node: AttributeToken) -> AttributeToken {
        if self.enabled {
            <V as Fold>::fold_attribute_token(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attribute_tokens(&mut self, node: Vec<AttributeToken>) -> Vec<AttributeToken> {
        if self.enabled {
            <V as Fold>::fold_attribute_tokens(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attributes(&mut self, node: Vec<Attribute>) -> Vec<Attribute> {
        if self.enabled {
            <V as Fold>::fold_attributes(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_child(&mut self, node: Child) -> Child {
        if self.enabled {
            <V as Fold>::fold_child(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>) -> Vec<Child> {
        if self.enabled {
            <V as Fold>::fold_childs(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment) -> Comment {
        if self.enabled {
            <V as Fold>::fold_comment(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document(&mut self, node: Document) -> Document {
        if self.enabled {
            <V as Fold>::fold_document(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document_fragment(&mut self, node: DocumentFragment) -> DocumentFragment {
        if self.enabled {
            <V as Fold>::fold_document_fragment(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document_mode(&mut self, node: DocumentMode) -> DocumentMode {
        if self.enabled {
            <V as Fold>::fold_document_mode(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document_type(&mut self, node: DocumentType) -> DocumentType {
        if self.enabled {
            <V as Fold>::fold_document_type(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_element(&mut self, node: Element) -> Element {
        if self.enabled {
            <V as Fold>::fold_element(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace) -> Namespace {
        if self.enabled {
            <V as Fold>::fold_namespace(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_atom(&mut self, node: Option<swc_atoms::Atom>) -> Option<swc_atoms::Atom> {
        if self.enabled {
            <V as Fold>::fold_opt_atom(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
    ) -> Option<DocumentFragment> {
        if self.enabled {
            <V as Fold>::fold_opt_document_fragment(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_namespace(&mut self, node: Option<Namespace>) -> Option<Namespace> {
        if self.enabled {
            <V as Fold>::fold_opt_namespace(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>) -> Option<Raw> {
        if self.enabled {
            <V as Fold>::fold_opt_raw(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw) -> Raw {
        if self.enabled {
            <V as Fold>::fold_raw(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_span(&mut self, node: swc_common::Span) -> swc_common::Span {
        if self.enabled {
            <V as Fold>::fold_span(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_text(&mut self, node: Text) -> Text {
        if self.enabled {
            <V as Fold>::fold_text(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_token(&mut self, node: Token) -> Token {
        if self.enabled {
            <V as Fold>::fold_token(&mut self.visitor, node)
        } else {
            node
        }
    }

    #[inline]
    fn fold_token_and_span(&mut self, node: TokenAndSpan) -> TokenAndSpan {
        if self.enabled {
            <V as Fold>::fold_token_and_span(&mut self.visitor, node)
        } else {
            node
        }
    }
}
#[doc = r" A trait implemented for types that can be visited using a visitor."]
pub trait FoldWith<V: ?Sized + Fold> {
    #[doc = r" Calls a visitor method (visitor.fold_xxx) with self."]
    fn fold_with(self, visitor: &mut V) -> Self;
    #[doc = r" Visit children nodes of `self`` with `visitor`."]
    fn fold_children_with(self, visitor: &mut V) -> Self;
}
impl<V: ?Sized + Fold> FoldWith<V> for Attribute {
    #[doc = "Calls [Fold`::fold_attribute`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_attribute(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Attribute {
                span,
                namespace,
                prefix,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let namespace =
                    { <Option<Namespace> as FoldWith<V>>::fold_with(namespace, visitor) };
                let prefix =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(prefix, visitor) };
                let name = { <swc_atoms::Atom as FoldWith<V>>::fold_with(name, visitor) };
                let raw_name =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw_name, visitor) };
                let value = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(value, visitor) };
                let raw_value =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw_value, visitor) };
                Attribute {
                    span,
                    namespace,
                    prefix,
                    name,
                    raw_name,
                    value,
                    raw_value,
                }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for AttributeToken {
    #[doc = "Calls [Fold`::fold_attribute_token`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_attribute_token(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            AttributeToken {
                span,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let name = { <swc_atoms::Atom as FoldWith<V>>::fold_with(name, visitor) };
                let raw_name =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw_name, visitor) };
                let value = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(value, visitor) };
                let raw_value =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw_value, visitor) };
                AttributeToken {
                    span,
                    name,
                    raw_name,
                    value,
                    raw_value,
                }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Child {
    #[doc = "Calls [Fold`::fold_child`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_child(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Child::DocumentType { 0: _field_0 } => {
                let _field_0 = <DocumentType as FoldWith<V>>::fold_with(_field_0, visitor);
                Child::DocumentType { 0: _field_0 }
            }
            Child::Element { 0: _field_0 } => {
                let _field_0 = <Element as FoldWith<V>>::fold_with(_field_0, visitor);
                Child::Element { 0: _field_0 }
            }
            Child::Text { 0: _field_0 } => {
                let _field_0 = <Text as FoldWith<V>>::fold_with(_field_0, visitor);
                Child::Text { 0: _field_0 }
            }
            Child::Comment { 0: _field_0 } => {
                let _field_0 = <Comment as FoldWith<V>>::fold_with(_field_0, visitor);
                Child::Comment { 0: _field_0 }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Comment {
    #[doc = "Calls [Fold`::fold_comment`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_comment(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Comment { span, data, raw } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let data = { <swc_atoms::Atom as FoldWith<V>>::fold_with(data, visitor) };
                let raw = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw, visitor) };
                Comment { span, data, raw }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Document {
    #[doc = "Calls [Fold`::fold_document`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_document(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Document {
                span,
                mode,
                children,
            } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let mode = { <DocumentMode as FoldWith<V>>::fold_with(mode, visitor) };
                let children = { <Vec<Child> as FoldWith<V>>::fold_with(children, visitor) };
                Document {
                    span,
                    mode,
                    children,
                }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for DocumentFragment {
    #[doc = "Calls [Fold`::fold_document_fragment`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_document_fragment(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            DocumentFragment { span, children } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let children = { <Vec<Child> as FoldWith<V>>::fold_with(children, visitor) };
                DocumentFragment { span, children }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for DocumentMode {
    #[doc = "Calls [Fold`::fold_document_mode`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_document_mode(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            DocumentMode::NoQuirks => DocumentMode::NoQuirks,
            DocumentMode::LimitedQuirks => DocumentMode::LimitedQuirks,
            DocumentMode::Quirks => DocumentMode::Quirks,
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for DocumentType {
    #[doc = "Calls [Fold`::fold_document_type`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_document_type(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            DocumentType {
                span,
                name,
                public_id,
                system_id,
                raw,
            } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let name = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(name, visitor) };
                let public_id =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(public_id, visitor) };
                let system_id =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(system_id, visitor) };
                let raw = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw, visitor) };
                DocumentType {
                    span,
                    name,
                    public_id,
                    system_id,
                    raw,
                }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Element {
    #[doc = "Calls [Fold`::fold_element`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_element(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Element {
                span,
                tag_name,
                namespace,
                attributes,
                children,
                content,
                is_self_closing,
            } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let tag_name = { <swc_atoms::Atom as FoldWith<V>>::fold_with(tag_name, visitor) };
                let namespace = { <Namespace as FoldWith<V>>::fold_with(namespace, visitor) };
                let attributes =
                    { <Vec<Attribute> as FoldWith<V>>::fold_with(attributes, visitor) };
                let children = { <Vec<Child> as FoldWith<V>>::fold_with(children, visitor) };
                let content =
                    { <Option<DocumentFragment> as FoldWith<V>>::fold_with(content, visitor) };
                Element {
                    span,
                    tag_name,
                    namespace,
                    attributes,
                    children,
                    content,
                    is_self_closing,
                }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Namespace {
    #[doc = "Calls [Fold`::fold_namespace`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_namespace(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Namespace::HTML => Namespace::HTML,
            Namespace::MATHML => Namespace::MATHML,
            Namespace::SVG => Namespace::SVG,
            Namespace::XLINK => Namespace::XLINK,
            Namespace::XML => Namespace::XML,
            Namespace::XMLNS => Namespace::XMLNS,
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Raw {
    #[doc = "Calls [Fold`::fold_raw`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_raw(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Raw::Same => Raw::Same,
            Raw::Atom { 0: _field_0 } => {
                let _field_0 = <swc_atoms::Atom as FoldWith<V>>::fold_with(_field_0, visitor);
                Raw::Atom { 0: _field_0 }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Text {
    #[doc = "Calls [Fold`::fold_text`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_text(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Text { span, data, raw } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let data = { <swc_atoms::Atom as FoldWith<V>>::fold_with(data, visitor) };
                let raw = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw, visitor) };
                Text { span, data, raw }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Token {
    #[doc = "Calls [Fold`::fold_token`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_token(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            Token::Doctype {
                name,
                force_quirks,
                public_id,
                system_id,
                raw,
            } => {
                let name = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(name, visitor) };
                let public_id =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(public_id, visitor) };
                let system_id =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(system_id, visitor) };
                let raw = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw, visitor) };
                Token::Doctype {
                    name,
                    force_quirks,
                    public_id,
                    system_id,
                    raw,
                }
            }
            Token::StartTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let tag_name = { <swc_atoms::Atom as FoldWith<V>>::fold_with(tag_name, visitor) };
                let raw_tag_name =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw_tag_name, visitor) };
                let attributes =
                    { <Vec<AttributeToken> as FoldWith<V>>::fold_with(attributes, visitor) };
                Token::StartTag {
                    tag_name,
                    raw_tag_name,
                    is_self_closing,
                    attributes,
                }
            }
            Token::EndTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let tag_name = { <swc_atoms::Atom as FoldWith<V>>::fold_with(tag_name, visitor) };
                let raw_tag_name =
                    { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw_tag_name, visitor) };
                let attributes =
                    { <Vec<AttributeToken> as FoldWith<V>>::fold_with(attributes, visitor) };
                Token::EndTag {
                    tag_name,
                    raw_tag_name,
                    is_self_closing,
                    attributes,
                }
            }
            Token::Comment { data, raw } => {
                let data = { <swc_atoms::Atom as FoldWith<V>>::fold_with(data, visitor) };
                let raw = { <Option<swc_atoms::Atom> as FoldWith<V>>::fold_with(raw, visitor) };
                Token::Comment { data, raw }
            }
            Token::Character { value, raw } => {
                let raw = { <Option<Raw> as FoldWith<V>>::fold_with(raw, visitor) };
                Token::Character { value, raw }
            }
            Token::Eof => Token::Eof,
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for TokenAndSpan {
    #[doc = "Calls [Fold`::fold_token_and_span`] with `self`."]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_token_and_span(visitor, self)
    }

    fn fold_children_with(self, visitor: &mut V) -> Self {
        match self {
            TokenAndSpan { span, token } => {
                let span = { <swc_common::Span as FoldWith<V>>::fold_with(span, visitor) };
                let token = { <Token as FoldWith<V>>::fold_with(token, visitor) };
                TokenAndSpan { span, token }
            }
        }
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for swc_atoms::Atom {
    #[doc = "Calls [Fold`::fold_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_atom(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        self
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Vec<AttributeToken> {
    #[doc = "Calls [Fold`::fold_attribute_tokens`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_attribute_tokens(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        swc_visit::util::move_map::MoveMap::move_map(self, |item| {
            <AttributeToken as FoldWith<V>>::fold_with(item, visitor)
        })
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Vec<Attribute> {
    #[doc = "Calls [Fold`::fold_attributes`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_attributes(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        swc_visit::util::move_map::MoveMap::move_map(self, |item| {
            <Attribute as FoldWith<V>>::fold_with(item, visitor)
        })
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Vec<Child> {
    #[doc = "Calls [Fold`::fold_childs`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_childs(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        swc_visit::util::move_map::MoveMap::move_map(self, |item| {
            <Child as FoldWith<V>>::fold_with(item, visitor)
        })
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Option<swc_atoms::Atom> {
    #[doc = "Calls [Fold`::fold_opt_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_opt_atom(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        self.map(|inner| <swc_atoms::Atom as FoldWith<V>>::fold_with(inner, visitor))
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Option<DocumentFragment> {
    #[doc = "Calls [Fold`::fold_opt_document_fragment`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_opt_document_fragment(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        self.map(|inner| <DocumentFragment as FoldWith<V>>::fold_with(inner, visitor))
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Option<Namespace> {
    #[doc = "Calls [Fold`::fold_opt_namespace`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_opt_namespace(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        self.map(|inner| <Namespace as FoldWith<V>>::fold_with(inner, visitor))
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for Option<Raw> {
    #[doc = "Calls [Fold`::fold_opt_raw`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_opt_raw(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        self.map(|inner| <Raw as FoldWith<V>>::fold_with(inner, visitor))
    }
}
impl<V: ?Sized + Fold> FoldWith<V> for swc_common::Span {
    #[doc = "Calls [Fold`::fold_span`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        <V as Fold>::fold_span(visitor, self)
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        self
    }
}
impl<V, T> FoldWith<V> for std::boxed::Box<T>
where
    V: ?Sized + Fold,
    T: FoldWith<V>,
{
    #[inline]
    fn fold_with(self, visitor: &mut V) -> Self {
        swc_visit::util::map::Map::map(self, |inner| <T as FoldWith<V>>::fold_with(inner, visitor))
    }

    #[inline]
    fn fold_children_with(self, visitor: &mut V) -> Self {
        swc_visit::util::map::Map::map(self, |inner| {
            <T as FoldWith<V>>::fold_children_with(inner, visitor)
        })
    }
}
#[doc = r" A visitor trait for traversing the AST."]
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
pub trait FoldAstPath {
    #[doc = "Visit a node of type `swc_atoms :: Atom`.\n\nBy default, this method calls \
             [`swc_atoms :: Atom::fold_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn fold_atom(
        &mut self,
        node: swc_atoms::Atom,
        __ast_path: &mut AstKindPath,
    ) -> swc_atoms::Atom {
        <swc_atoms::Atom as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Attribute`.\n\nBy default, this method calls \
             [`Attribute::fold_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn fold_attribute(&mut self, node: Attribute, __ast_path: &mut AstKindPath) -> Attribute {
        <Attribute as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `AttributeToken`.\n\nBy default, this method calls \
             [`AttributeToken::fold_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn fold_attribute_token(
        &mut self,
        node: AttributeToken,
        __ast_path: &mut AstKindPath,
    ) -> AttributeToken {
        <AttributeToken as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < AttributeToken >`.\n\nBy default, this method calls [`Vec \
             < AttributeToken >::fold_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn fold_attribute_tokens(
        &mut self,
        node: Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<AttributeToken> {
        <Vec<AttributeToken> as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Vec < Attribute >`.\n\nBy default, this method calls [`Vec < \
             Attribute >::fold_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn fold_attributes(
        &mut self,
        node: Vec<Attribute>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<Attribute> {
        <Vec<Attribute> as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Child`.\n\nBy default, this method calls \
             [`Child::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_child(&mut self, node: Child, __ast_path: &mut AstKindPath) -> Child {
        <Child as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Vec < Child >`.\n\nBy default, this method calls [`Vec < Child \
             >::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>, __ast_path: &mut AstKindPath) -> Vec<Child> {
        <Vec<Child> as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Comment`.\n\nBy default, this method calls \
             [`Comment::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_comment(&mut self, node: Comment, __ast_path: &mut AstKindPath) -> Comment {
        <Comment as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Document`.\n\nBy default, this method calls \
             [`Document::fold_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn fold_document(&mut self, node: Document, __ast_path: &mut AstKindPath) -> Document {
        <Document as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `DocumentFragment`.\n\nBy default, this method calls \
             [`DocumentFragment::fold_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn fold_document_fragment(
        &mut self,
        node: DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) -> DocumentFragment {
        <DocumentFragment as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `DocumentMode`.\n\nBy default, this method calls \
             [`DocumentMode::fold_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn fold_document_mode(
        &mut self,
        node: DocumentMode,
        __ast_path: &mut AstKindPath,
    ) -> DocumentMode {
        <DocumentMode as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `DocumentType`.\n\nBy default, this method calls \
             [`DocumentType::fold_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn fold_document_type(
        &mut self,
        node: DocumentType,
        __ast_path: &mut AstKindPath,
    ) -> DocumentType {
        <DocumentType as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Element`.\n\nBy default, this method calls \
             [`Element::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_element(&mut self, node: Element, __ast_path: &mut AstKindPath) -> Element {
        <Element as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Namespace`.\n\nBy default, this method calls \
             [`Namespace::fold_children_with_ast_path`]. If you want to recurse, you need to call \
             it manually."]
    #[inline]
    fn fold_namespace(&mut self, node: Namespace, __ast_path: &mut AstKindPath) -> Namespace {
        <Namespace as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Option < swc_atoms :: Atom >`.\n\nBy default, this method calls \
             [`Option < swc_atoms :: Atom >::fold_children_with_ast_path`]. If you want to \
             recurse, you need to call it manually."]
    #[inline]
    fn fold_opt_atom(
        &mut self,
        node: Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) -> Option<swc_atoms::Atom> {
        <Option<swc_atoms::Atom> as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < DocumentFragment >`.\n\nBy default, this method calls \
             [`Option < DocumentFragment >::fold_children_with_ast_path`]. If you want to recurse, \
             you need to call it manually."]
    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) -> Option<DocumentFragment> {
        <Option<DocumentFragment> as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < Namespace >`.\n\nBy default, this method calls \
             [`Option < Namespace >::fold_children_with_ast_path`]. If you want to recurse, you \
             need to call it manually."]
    #[inline]
    fn fold_opt_namespace(
        &mut self,
        node: Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) -> Option<Namespace> {
        <Option<Namespace> as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Option < Raw >`.\n\nBy default, this method calls [`Option < \
             Raw >::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>, __ast_path: &mut AstKindPath) -> Option<Raw> {
        <Option<Raw> as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Raw`.\n\nBy default, this method calls \
             [`Raw::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_raw(&mut self, node: Raw, __ast_path: &mut AstKindPath) -> Raw {
        <Raw as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `swc_common :: Span`.\n\nBy default, this method calls \
             [`swc_common :: Span::fold_children_with_ast_path`]. If you want to recurse, you need \
             to call it manually."]
    #[inline]
    fn fold_span(
        &mut self,
        node: swc_common::Span,
        __ast_path: &mut AstKindPath,
    ) -> swc_common::Span {
        <swc_common::Span as FoldWithAstPath<Self>>::fold_children_with_ast_path(
            node, self, __ast_path,
        )
    }
    #[doc = "Visit a node of type `Text`.\n\nBy default, this method calls \
             [`Text::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_text(&mut self, node: Text, __ast_path: &mut AstKindPath) -> Text {
        <Text as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `Token`.\n\nBy default, this method calls \
             [`Token::fold_children_with_ast_path`]. If you want to recurse, you need to call it \
             manually."]
    #[inline]
    fn fold_token(&mut self, node: Token, __ast_path: &mut AstKindPath) -> Token {
        <Token as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
    #[doc = "Visit a node of type `TokenAndSpan`.\n\nBy default, this method calls \
             [`TokenAndSpan::fold_children_with_ast_path`]. If you want to recurse, you need to \
             call it manually."]
    #[inline]
    fn fold_token_and_span(
        &mut self,
        node: TokenAndSpan,
        __ast_path: &mut AstKindPath,
    ) -> TokenAndSpan {
        <TokenAndSpan as FoldWithAstPath<Self>>::fold_children_with_ast_path(node, self, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> FoldAstPath for &mut V
where
    V: ?Sized + FoldAstPath,
{
    #[inline]
    fn fold_atom(
        &mut self,
        node: swc_atoms::Atom,
        __ast_path: &mut AstKindPath,
    ) -> swc_atoms::Atom {
        <V as FoldAstPath>::fold_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute, __ast_path: &mut AstKindPath) -> Attribute {
        <V as FoldAstPath>::fold_attribute(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attribute_token(
        &mut self,
        node: AttributeToken,
        __ast_path: &mut AstKindPath,
    ) -> AttributeToken {
        <V as FoldAstPath>::fold_attribute_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attribute_tokens(
        &mut self,
        node: Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<AttributeToken> {
        <V as FoldAstPath>::fold_attribute_tokens(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attributes(
        &mut self,
        node: Vec<Attribute>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<Attribute> {
        <V as FoldAstPath>::fold_attributes(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_child(&mut self, node: Child, __ast_path: &mut AstKindPath) -> Child {
        <V as FoldAstPath>::fold_child(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>, __ast_path: &mut AstKindPath) -> Vec<Child> {
        <V as FoldAstPath>::fold_childs(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment, __ast_path: &mut AstKindPath) -> Comment {
        <V as FoldAstPath>::fold_comment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document(&mut self, node: Document, __ast_path: &mut AstKindPath) -> Document {
        <V as FoldAstPath>::fold_document(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document_fragment(
        &mut self,
        node: DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) -> DocumentFragment {
        <V as FoldAstPath>::fold_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document_mode(
        &mut self,
        node: DocumentMode,
        __ast_path: &mut AstKindPath,
    ) -> DocumentMode {
        <V as FoldAstPath>::fold_document_mode(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document_type(
        &mut self,
        node: DocumentType,
        __ast_path: &mut AstKindPath,
    ) -> DocumentType {
        <V as FoldAstPath>::fold_document_type(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_element(&mut self, node: Element, __ast_path: &mut AstKindPath) -> Element {
        <V as FoldAstPath>::fold_element(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace, __ast_path: &mut AstKindPath) -> Namespace {
        <V as FoldAstPath>::fold_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_atom(
        &mut self,
        node: Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) -> Option<swc_atoms::Atom> {
        <V as FoldAstPath>::fold_opt_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) -> Option<DocumentFragment> {
        <V as FoldAstPath>::fold_opt_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_namespace(
        &mut self,
        node: Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) -> Option<Namespace> {
        <V as FoldAstPath>::fold_opt_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>, __ast_path: &mut AstKindPath) -> Option<Raw> {
        <V as FoldAstPath>::fold_opt_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw, __ast_path: &mut AstKindPath) -> Raw {
        <V as FoldAstPath>::fold_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_span(
        &mut self,
        node: swc_common::Span,
        __ast_path: &mut AstKindPath,
    ) -> swc_common::Span {
        <V as FoldAstPath>::fold_span(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_text(&mut self, node: Text, __ast_path: &mut AstKindPath) -> Text {
        <V as FoldAstPath>::fold_text(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_token(&mut self, node: Token, __ast_path: &mut AstKindPath) -> Token {
        <V as FoldAstPath>::fold_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_token_and_span(
        &mut self,
        node: TokenAndSpan,
        __ast_path: &mut AstKindPath,
    ) -> TokenAndSpan {
        <V as FoldAstPath>::fold_token_and_span(&mut **self, node, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> FoldAstPath for Box<V>
where
    V: ?Sized + FoldAstPath,
{
    #[inline]
    fn fold_atom(
        &mut self,
        node: swc_atoms::Atom,
        __ast_path: &mut AstKindPath,
    ) -> swc_atoms::Atom {
        <V as FoldAstPath>::fold_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute, __ast_path: &mut AstKindPath) -> Attribute {
        <V as FoldAstPath>::fold_attribute(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attribute_token(
        &mut self,
        node: AttributeToken,
        __ast_path: &mut AstKindPath,
    ) -> AttributeToken {
        <V as FoldAstPath>::fold_attribute_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attribute_tokens(
        &mut self,
        node: Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<AttributeToken> {
        <V as FoldAstPath>::fold_attribute_tokens(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_attributes(
        &mut self,
        node: Vec<Attribute>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<Attribute> {
        <V as FoldAstPath>::fold_attributes(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_child(&mut self, node: Child, __ast_path: &mut AstKindPath) -> Child {
        <V as FoldAstPath>::fold_child(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>, __ast_path: &mut AstKindPath) -> Vec<Child> {
        <V as FoldAstPath>::fold_childs(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment, __ast_path: &mut AstKindPath) -> Comment {
        <V as FoldAstPath>::fold_comment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document(&mut self, node: Document, __ast_path: &mut AstKindPath) -> Document {
        <V as FoldAstPath>::fold_document(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document_fragment(
        &mut self,
        node: DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) -> DocumentFragment {
        <V as FoldAstPath>::fold_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document_mode(
        &mut self,
        node: DocumentMode,
        __ast_path: &mut AstKindPath,
    ) -> DocumentMode {
        <V as FoldAstPath>::fold_document_mode(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_document_type(
        &mut self,
        node: DocumentType,
        __ast_path: &mut AstKindPath,
    ) -> DocumentType {
        <V as FoldAstPath>::fold_document_type(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_element(&mut self, node: Element, __ast_path: &mut AstKindPath) -> Element {
        <V as FoldAstPath>::fold_element(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace, __ast_path: &mut AstKindPath) -> Namespace {
        <V as FoldAstPath>::fold_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_atom(
        &mut self,
        node: Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) -> Option<swc_atoms::Atom> {
        <V as FoldAstPath>::fold_opt_atom(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) -> Option<DocumentFragment> {
        <V as FoldAstPath>::fold_opt_document_fragment(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_namespace(
        &mut self,
        node: Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) -> Option<Namespace> {
        <V as FoldAstPath>::fold_opt_namespace(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>, __ast_path: &mut AstKindPath) -> Option<Raw> {
        <V as FoldAstPath>::fold_opt_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw, __ast_path: &mut AstKindPath) -> Raw {
        <V as FoldAstPath>::fold_raw(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_span(
        &mut self,
        node: swc_common::Span,
        __ast_path: &mut AstKindPath,
    ) -> swc_common::Span {
        <V as FoldAstPath>::fold_span(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_text(&mut self, node: Text, __ast_path: &mut AstKindPath) -> Text {
        <V as FoldAstPath>::fold_text(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_token(&mut self, node: Token, __ast_path: &mut AstKindPath) -> Token {
        <V as FoldAstPath>::fold_token(&mut **self, node, __ast_path)
    }

    #[inline]
    fn fold_token_and_span(
        &mut self,
        node: TokenAndSpan,
        __ast_path: &mut AstKindPath,
    ) -> TokenAndSpan {
        <V as FoldAstPath>::fold_token_and_span(&mut **self, node, __ast_path)
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<A, B> FoldAstPath for ::swc_visit::Either<A, B>
where
    A: FoldAstPath,
    B: FoldAstPath,
{
    #[inline]
    fn fold_atom(
        &mut self,
        node: swc_atoms::Atom,
        __ast_path: &mut AstKindPath,
    ) -> swc_atoms::Atom {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_atom(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => FoldAstPath::fold_atom(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute, __ast_path: &mut AstKindPath) -> Attribute {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_attribute(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_attribute(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_attribute_token(
        &mut self,
        node: AttributeToken,
        __ast_path: &mut AstKindPath,
    ) -> AttributeToken {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_attribute_token(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_attribute_token(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_attribute_tokens(
        &mut self,
        node: Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<AttributeToken> {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_attribute_tokens(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_attribute_tokens(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_attributes(
        &mut self,
        node: Vec<Attribute>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<Attribute> {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_attributes(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_attributes(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_child(&mut self, node: Child, __ast_path: &mut AstKindPath) -> Child {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_child(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => FoldAstPath::fold_child(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>, __ast_path: &mut AstKindPath) -> Vec<Child> {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_childs(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_childs(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment, __ast_path: &mut AstKindPath) -> Comment {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_comment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_comment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_document(&mut self, node: Document, __ast_path: &mut AstKindPath) -> Document {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_document(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_document(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_document_fragment(
        &mut self,
        node: DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) -> DocumentFragment {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_document_fragment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_document_fragment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_document_mode(
        &mut self,
        node: DocumentMode,
        __ast_path: &mut AstKindPath,
    ) -> DocumentMode {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_document_mode(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_document_mode(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_document_type(
        &mut self,
        node: DocumentType,
        __ast_path: &mut AstKindPath,
    ) -> DocumentType {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_document_type(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_document_type(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_element(&mut self, node: Element, __ast_path: &mut AstKindPath) -> Element {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_element(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_element(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace, __ast_path: &mut AstKindPath) -> Namespace {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_namespace(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_namespace(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_opt_atom(
        &mut self,
        node: Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) -> Option<swc_atoms::Atom> {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_opt_atom(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_opt_atom(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) -> Option<DocumentFragment> {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_opt_document_fragment(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_opt_document_fragment(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_opt_namespace(
        &mut self,
        node: Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) -> Option<Namespace> {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_opt_namespace(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_opt_namespace(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>, __ast_path: &mut AstKindPath) -> Option<Raw> {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_opt_raw(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_opt_raw(visitor, node, __ast_path)
            }
        }
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw, __ast_path: &mut AstKindPath) -> Raw {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_raw(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => FoldAstPath::fold_raw(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn fold_span(
        &mut self,
        node: swc_common::Span,
        __ast_path: &mut AstKindPath,
    ) -> swc_common::Span {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_span(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => FoldAstPath::fold_span(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn fold_text(&mut self, node: Text, __ast_path: &mut AstKindPath) -> Text {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_text(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => FoldAstPath::fold_text(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn fold_token(&mut self, node: Token, __ast_path: &mut AstKindPath) -> Token {
        match self {
            swc_visit::Either::Left(visitor) => FoldAstPath::fold_token(visitor, node, __ast_path),
            swc_visit::Either::Right(visitor) => FoldAstPath::fold_token(visitor, node, __ast_path),
        }
    }

    #[inline]
    fn fold_token_and_span(
        &mut self,
        node: TokenAndSpan,
        __ast_path: &mut AstKindPath,
    ) -> TokenAndSpan {
        match self {
            swc_visit::Either::Left(visitor) => {
                FoldAstPath::fold_token_and_span(visitor, node, __ast_path)
            }
            swc_visit::Either::Right(visitor) => {
                FoldAstPath::fold_token_and_span(visitor, node, __ast_path)
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V> FoldAstPath for ::swc_visit::Optional<V>
where
    V: FoldAstPath,
{
    #[inline]
    fn fold_atom(
        &mut self,
        node: swc_atoms::Atom,
        __ast_path: &mut AstKindPath,
    ) -> swc_atoms::Atom {
        if self.enabled {
            <V as FoldAstPath>::fold_atom(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attribute(&mut self, node: Attribute, __ast_path: &mut AstKindPath) -> Attribute {
        if self.enabled {
            <V as FoldAstPath>::fold_attribute(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attribute_token(
        &mut self,
        node: AttributeToken,
        __ast_path: &mut AstKindPath,
    ) -> AttributeToken {
        if self.enabled {
            <V as FoldAstPath>::fold_attribute_token(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attribute_tokens(
        &mut self,
        node: Vec<AttributeToken>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<AttributeToken> {
        if self.enabled {
            <V as FoldAstPath>::fold_attribute_tokens(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_attributes(
        &mut self,
        node: Vec<Attribute>,
        __ast_path: &mut AstKindPath,
    ) -> Vec<Attribute> {
        if self.enabled {
            <V as FoldAstPath>::fold_attributes(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_child(&mut self, node: Child, __ast_path: &mut AstKindPath) -> Child {
        if self.enabled {
            <V as FoldAstPath>::fold_child(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_childs(&mut self, node: Vec<Child>, __ast_path: &mut AstKindPath) -> Vec<Child> {
        if self.enabled {
            <V as FoldAstPath>::fold_childs(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_comment(&mut self, node: Comment, __ast_path: &mut AstKindPath) -> Comment {
        if self.enabled {
            <V as FoldAstPath>::fold_comment(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document(&mut self, node: Document, __ast_path: &mut AstKindPath) -> Document {
        if self.enabled {
            <V as FoldAstPath>::fold_document(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document_fragment(
        &mut self,
        node: DocumentFragment,
        __ast_path: &mut AstKindPath,
    ) -> DocumentFragment {
        if self.enabled {
            <V as FoldAstPath>::fold_document_fragment(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document_mode(
        &mut self,
        node: DocumentMode,
        __ast_path: &mut AstKindPath,
    ) -> DocumentMode {
        if self.enabled {
            <V as FoldAstPath>::fold_document_mode(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_document_type(
        &mut self,
        node: DocumentType,
        __ast_path: &mut AstKindPath,
    ) -> DocumentType {
        if self.enabled {
            <V as FoldAstPath>::fold_document_type(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_element(&mut self, node: Element, __ast_path: &mut AstKindPath) -> Element {
        if self.enabled {
            <V as FoldAstPath>::fold_element(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_namespace(&mut self, node: Namespace, __ast_path: &mut AstKindPath) -> Namespace {
        if self.enabled {
            <V as FoldAstPath>::fold_namespace(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_atom(
        &mut self,
        node: Option<swc_atoms::Atom>,
        __ast_path: &mut AstKindPath,
    ) -> Option<swc_atoms::Atom> {
        if self.enabled {
            <V as FoldAstPath>::fold_opt_atom(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_document_fragment(
        &mut self,
        node: Option<DocumentFragment>,
        __ast_path: &mut AstKindPath,
    ) -> Option<DocumentFragment> {
        if self.enabled {
            <V as FoldAstPath>::fold_opt_document_fragment(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_namespace(
        &mut self,
        node: Option<Namespace>,
        __ast_path: &mut AstKindPath,
    ) -> Option<Namespace> {
        if self.enabled {
            <V as FoldAstPath>::fold_opt_namespace(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_opt_raw(&mut self, node: Option<Raw>, __ast_path: &mut AstKindPath) -> Option<Raw> {
        if self.enabled {
            <V as FoldAstPath>::fold_opt_raw(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_raw(&mut self, node: Raw, __ast_path: &mut AstKindPath) -> Raw {
        if self.enabled {
            <V as FoldAstPath>::fold_raw(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_span(
        &mut self,
        node: swc_common::Span,
        __ast_path: &mut AstKindPath,
    ) -> swc_common::Span {
        if self.enabled {
            <V as FoldAstPath>::fold_span(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_text(&mut self, node: Text, __ast_path: &mut AstKindPath) -> Text {
        if self.enabled {
            <V as FoldAstPath>::fold_text(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_token(&mut self, node: Token, __ast_path: &mut AstKindPath) -> Token {
        if self.enabled {
            <V as FoldAstPath>::fold_token(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }

    #[inline]
    fn fold_token_and_span(
        &mut self,
        node: TokenAndSpan,
        __ast_path: &mut AstKindPath,
    ) -> TokenAndSpan {
        if self.enabled {
            <V as FoldAstPath>::fold_token_and_span(&mut self.visitor, node, __ast_path)
        } else {
            node
        }
    }
}
#[doc = r" A trait implemented for types that can be visited using a visitor."]
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
pub trait FoldWithAstPath<V: ?Sized + FoldAstPath> {
    #[doc = r" Calls a visitor method (visitor.fold_xxx) with self."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self;
    #[doc = r" Visit children nodes of `self`` with `visitor`."]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self;
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Attribute {
    #[doc = "Calls [FoldAstPath`::fold_attribute`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_attribute(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Attribute {
                span,
                namespace,
                prefix,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                let span = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Attribute(self::fields::AttributeField::Span));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let namespace = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::Namespace,
                    ));
                    <Option<Namespace> as FoldWithAstPath<V>>::fold_with_ast_path(
                        namespace,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let prefix = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::Prefix,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        prefix,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let name = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Attribute(self::fields::AttributeField::Name));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw_name = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::RawName,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let value = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::Value,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw_value = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Attribute(
                        self::fields::AttributeField::RawValue,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw_value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Attribute {
                    span,
                    namespace,
                    prefix,
                    name,
                    raw_name,
                    value,
                    raw_value,
                }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for AttributeToken {
    #[doc = "Calls [FoldAstPath`::fold_attribute_token`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_attribute_token(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            AttributeToken {
                span,
                name,
                raw_name,
                value,
                raw_value,
            } => {
                let span = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::Span,
                    ));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let name = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::Name,
                    ));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw_name = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::RawName,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let value = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::Value,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw_value = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::AttributeToken(
                        self::fields::AttributeTokenField::RawValue,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw_value,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                AttributeToken {
                    span,
                    name,
                    raw_name,
                    value,
                    raw_value,
                }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Child {
    #[doc = "Calls [FoldAstPath`::fold_child`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_child(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Child::DocumentType { 0: _field_0 } => {
                let mut __ast_path = __ast_path
                    .with_guard(AstParentKind::Child(self::fields::ChildField::DocumentType));
                let _field_0 = <DocumentType as FoldWithAstPath<V>>::fold_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
                Child::DocumentType { 0: _field_0 }
            }
            Child::Element { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Child(self::fields::ChildField::Element));
                let _field_0 = <Element as FoldWithAstPath<V>>::fold_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
                Child::Element { 0: _field_0 }
            }
            Child::Text { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Child(self::fields::ChildField::Text));
                let _field_0 = <Text as FoldWithAstPath<V>>::fold_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
                Child::Text { 0: _field_0 }
            }
            Child::Comment { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Child(self::fields::ChildField::Comment));
                let _field_0 = <Comment as FoldWithAstPath<V>>::fold_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
                Child::Comment { 0: _field_0 }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Comment {
    #[doc = "Calls [FoldAstPath`::fold_comment`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_comment(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Comment { span, data, raw } => {
                let span = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Comment(self::fields::CommentField::Span));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let data = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Comment(self::fields::CommentField::Data));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Comment(self::fields::CommentField::Raw));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Comment { span, data, raw }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Document {
    #[doc = "Calls [FoldAstPath`::fold_document`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_document(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Document {
                span,
                mode,
                children,
            } => {
                let span = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Document(self::fields::DocumentField::Span));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let mode = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Document(self::fields::DocumentField::Mode));
                    <DocumentMode as FoldWithAstPath<V>>::fold_with_ast_path(
                        mode,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let children = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Document(
                        self::fields::DocumentField::Children(usize::MAX),
                    ));
                    <Vec<Child> as FoldWithAstPath<V>>::fold_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Document {
                    span,
                    mode,
                    children,
                }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for DocumentFragment {
    #[doc = "Calls [FoldAstPath`::fold_document_fragment`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_document_fragment(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            DocumentFragment { span, children } => {
                let span = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentFragment(
                        self::fields::DocumentFragmentField::Span,
                    ));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let children = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentFragment(
                        self::fields::DocumentFragmentField::Children(usize::MAX),
                    ));
                    <Vec<Child> as FoldWithAstPath<V>>::fold_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                DocumentFragment { span, children }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for DocumentMode {
    #[doc = "Calls [FoldAstPath`::fold_document_mode`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_document_mode(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            DocumentMode::NoQuirks => DocumentMode::NoQuirks,
            DocumentMode::LimitedQuirks => DocumentMode::LimitedQuirks,
            DocumentMode::Quirks => DocumentMode::Quirks,
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for DocumentType {
    #[doc = "Calls [FoldAstPath`::fold_document_type`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_document_type(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            DocumentType {
                span,
                name,
                public_id,
                system_id,
                raw,
            } => {
                let span = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::Span,
                    ));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let name = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::Name,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let public_id = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::PublicId,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        public_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let system_id = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::SystemId,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        system_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::DocumentType(
                        self::fields::DocumentTypeField::Raw,
                    ));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                DocumentType {
                    span,
                    name,
                    public_id,
                    system_id,
                    raw,
                }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Element {
    #[doc = "Calls [FoldAstPath`::fold_element`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_element(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Element {
                span,
                tag_name,
                namespace,
                attributes,
                children,
                content,
                is_self_closing,
            } => {
                let span = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Element(self::fields::ElementField::Span));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let tag_name = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Element(self::fields::ElementField::TagName));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let namespace = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Element(
                        self::fields::ElementField::Namespace,
                    ));
                    <Namespace as FoldWithAstPath<V>>::fold_with_ast_path(
                        namespace,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let attributes = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Element(
                        self::fields::ElementField::Attributes(usize::MAX),
                    ));
                    <Vec<Attribute> as FoldWithAstPath<V>>::fold_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let children = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Element(
                        self::fields::ElementField::Children(usize::MAX),
                    ));
                    <Vec<Child> as FoldWithAstPath<V>>::fold_with_ast_path(
                        children,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let content = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Element(self::fields::ElementField::Content));
                    <Option<DocumentFragment> as FoldWithAstPath<V>>::fold_with_ast_path(
                        content,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Element {
                    span,
                    tag_name,
                    namespace,
                    attributes,
                    children,
                    content,
                    is_self_closing,
                }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Namespace {
    #[doc = "Calls [FoldAstPath`::fold_namespace`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_namespace(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Namespace::HTML => Namespace::HTML,
            Namespace::MATHML => Namespace::MATHML,
            Namespace::SVG => Namespace::SVG,
            Namespace::XLINK => Namespace::XLINK,
            Namespace::XML => Namespace::XML,
            Namespace::XMLNS => Namespace::XMLNS,
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Raw {
    #[doc = "Calls [FoldAstPath`::fold_raw`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_raw(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Raw::Same => Raw::Same,
            Raw::Atom { 0: _field_0 } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Raw(self::fields::RawField::Atom));
                let _field_0 = <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                    _field_0,
                    visitor,
                    &mut *__ast_path,
                );
                Raw::Atom { 0: _field_0 }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Text {
    #[doc = "Calls [FoldAstPath`::fold_text`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_text(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Text { span, data, raw } => {
                let span = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Text(self::fields::TextField::Span));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let data = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Text(self::fields::TextField::Data));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Text(self::fields::TextField::Raw));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Text { span, data, raw }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Token {
    #[doc = "Calls [FoldAstPath`::fold_token`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_token(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            Token::Doctype {
                name,
                force_quirks,
                public_id,
                system_id,
                raw,
            } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Doctype));
                let name = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Name));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let public_id = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::PublicId));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        public_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let system_id = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::SystemId));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        system_id,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Raw));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Token::Doctype {
                    name,
                    force_quirks,
                    public_id,
                    system_id,
                    raw,
                }
            }
            Token::StartTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::StartTag));
                let tag_name = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::TagName));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw_tag_name = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::RawTagName));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw_tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let attributes = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Token(
                        self::fields::TokenField::Attributes(usize::MAX),
                    ));
                    <Vec<AttributeToken> as FoldWithAstPath<V>>::fold_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Token::StartTag {
                    tag_name,
                    raw_tag_name,
                    is_self_closing,
                    attributes,
                }
            }
            Token::EndTag {
                tag_name,
                raw_tag_name,
                is_self_closing,
                attributes,
            } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::EndTag));
                let tag_name = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::TagName));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw_tag_name = {
                    let mut __ast_path = __ast_path
                        .with_guard(AstParentKind::Token(self::fields::TokenField::RawTagName));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw_tag_name,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let attributes = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::Token(
                        self::fields::TokenField::Attributes(usize::MAX),
                    ));
                    <Vec<AttributeToken> as FoldWithAstPath<V>>::fold_with_ast_path(
                        attributes,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Token::EndTag {
                    tag_name,
                    raw_tag_name,
                    is_self_closing,
                    attributes,
                }
            }
            Token::Comment { data, raw } => {
                let mut __ast_path =
                    __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Comment));
                let data = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Data));
                    <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(
                        data,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let raw = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Raw));
                    <Option<swc_atoms::Atom> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Token::Comment { data, raw }
            }
            Token::Character { value, raw } => {
                let mut __ast_path = __ast_path
                    .with_guard(AstParentKind::Token(self::fields::TokenField::Character));
                let raw = {
                    let mut __ast_path =
                        __ast_path.with_guard(AstParentKind::Token(self::fields::TokenField::Raw));
                    <Option<Raw> as FoldWithAstPath<V>>::fold_with_ast_path(
                        raw,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                Token::Character { value, raw }
            }
            Token::Eof => Token::Eof,
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for TokenAndSpan {
    #[doc = "Calls [FoldAstPath`::fold_token_and_span`] with `self`."]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_token_and_span(visitor, self, __ast_path)
    }

    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        match self {
            TokenAndSpan { span, token } => {
                let span = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::TokenAndSpan(
                        self::fields::TokenAndSpanField::Span,
                    ));
                    <swc_common::Span as FoldWithAstPath<V>>::fold_with_ast_path(
                        span,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                let token = {
                    let mut __ast_path = __ast_path.with_guard(AstParentKind::TokenAndSpan(
                        self::fields::TokenAndSpanField::Token,
                    ));
                    <Token as FoldWithAstPath<V>>::fold_with_ast_path(
                        token,
                        visitor,
                        &mut *__ast_path,
                    )
                };
                TokenAndSpan { span, token }
            }
        }
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for swc_atoms::Atom {
    #[doc = "Calls [FoldAstPath`::fold_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_atom(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Vec<AttributeToken> {
    #[doc = "Calls [FoldAstPath`::fold_attribute_tokens`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_attribute_tokens(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.into_iter()
            .enumerate()
            .map(|(__idx, item)| {
                let mut __ast_path = __ast_path.with_index_guard(__idx);
                <AttributeToken as FoldWithAstPath<V>>::fold_with_ast_path(
                    item,
                    visitor,
                    &mut *__ast_path,
                )
            })
            .collect()
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Vec<Attribute> {
    #[doc = "Calls [FoldAstPath`::fold_attributes`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_attributes(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.into_iter()
            .enumerate()
            .map(|(__idx, item)| {
                let mut __ast_path = __ast_path.with_index_guard(__idx);
                <Attribute as FoldWithAstPath<V>>::fold_with_ast_path(
                    item,
                    visitor,
                    &mut *__ast_path,
                )
            })
            .collect()
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Vec<Child> {
    #[doc = "Calls [FoldAstPath`::fold_childs`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_childs(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.into_iter()
            .enumerate()
            .map(|(__idx, item)| {
                let mut __ast_path = __ast_path.with_index_guard(__idx);
                <Child as FoldWithAstPath<V>>::fold_with_ast_path(item, visitor, &mut *__ast_path)
            })
            .collect()
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Option<swc_atoms::Atom> {
    #[doc = "Calls [FoldAstPath`::fold_opt_atom`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_opt_atom(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.map(|inner| {
            <swc_atoms::Atom as FoldWithAstPath<V>>::fold_with_ast_path(inner, visitor, __ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Option<DocumentFragment> {
    #[doc = "Calls [FoldAstPath`::fold_opt_document_fragment`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_opt_document_fragment(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.map(|inner| {
            <DocumentFragment as FoldWithAstPath<V>>::fold_with_ast_path(inner, visitor, __ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Option<Namespace> {
    #[doc = "Calls [FoldAstPath`::fold_opt_namespace`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_opt_namespace(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.map(|inner| {
            <Namespace as FoldWithAstPath<V>>::fold_with_ast_path(inner, visitor, __ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for Option<Raw> {
    #[doc = "Calls [FoldAstPath`::fold_opt_raw`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_opt_raw(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self.map(|inner| {
            <Raw as FoldWithAstPath<V>>::fold_with_ast_path(inner, visitor, __ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V: ?Sized + FoldAstPath> FoldWithAstPath<V> for swc_common::Span {
    #[doc = "Calls [FoldAstPath`::fold_span`] with `self`. (Extra impl)"]
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        <V as FoldAstPath>::fold_span(visitor, self, __ast_path)
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        self
    }
}
#[cfg(any(docsrs, feature = "path"))]
#[cfg_attr(docsrs, doc(cfg(feature = "path")))]
impl<V, T> FoldWithAstPath<V> for std::boxed::Box<T>
where
    V: ?Sized + FoldAstPath,
    T: FoldWithAstPath<V>,
{
    #[inline]
    fn fold_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        swc_visit::util::map::Map::map(self, |inner| {
            <T as FoldWithAstPath<V>>::fold_with_ast_path(inner, visitor, __ast_path)
        })
    }

    #[inline]
    fn fold_children_with_ast_path(self, visitor: &mut V, __ast_path: &mut AstKindPath) -> Self {
        swc_visit::util::map::Map::map(self, |inner| {
            <T as FoldWithAstPath<V>>::fold_children_with_ast_path(inner, visitor, __ast_path)
        })
    }
}
#[cfg(any(docsrs, feature = "path"))]
pub type AstKindPath = swc_visit::AstKindPath<AstParentKind>;
#[cfg(any(docsrs, feature = "path"))]
pub type AstNodePath<'ast> = swc_visit::AstNodePath<AstParentNodeRef<'ast>>;
#[cfg(any(docsrs, feature = "path"))]
pub mod fields {
    use swc_html_ast::*;
    #[inline(always)]
    fn assert_initial_index(idx: usize, index: usize) {
        #[cfg(debug_assertions)]
        if !(idx == usize::MAX || index == usize::MAX) {
            {
                panic!("Should be usize::MAX");
            }
        }
    }
    impl AttributeField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum AttributeField {
        #[doc = "Represents [`Attribute::span`]"]
        Span,
        #[doc = "Represents [`Attribute::namespace`]"]
        Namespace,
        #[doc = "Represents [`Attribute::prefix`]"]
        Prefix,
        #[doc = "Represents [`Attribute::name`]"]
        Name,
        #[doc = "Represents [`Attribute::raw_name`]"]
        RawName,
        #[doc = "Represents [`Attribute::value`]"]
        Value,
        #[doc = "Represents [`Attribute::raw_value`]"]
        RawValue,
    }
    impl AttributeTokenField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum AttributeTokenField {
        #[doc = "Represents [`AttributeToken::span`]"]
        Span,
        #[doc = "Represents [`AttributeToken::name`]"]
        Name,
        #[doc = "Represents [`AttributeToken::raw_name`]"]
        RawName,
        #[doc = "Represents [`AttributeToken::value`]"]
        Value,
        #[doc = "Represents [`AttributeToken::raw_value`]"]
        RawValue,
    }
    impl ChildField {
        #[inline(always)]
        pub(crate) fn set_index(&mut self, _: usize) {
            swc_visit::wrong_ast_path();
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum ChildField {
        #[doc = "Represents [`Child::DocumentType`]"]
        DocumentType,
        #[doc = "Represents [`Child::Element`]"]
        Element,
        #[doc = "Represents [`Child::Text`]"]
        Text,
        #[doc = "Represents [`Child::Comment`]"]
        Comment,
    }
    impl CommentField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum CommentField {
        #[doc = "Represents [`Comment::span`]"]
        Span,
        #[doc = "Represents [`Comment::data`]"]
        Data,
        #[doc = "Represents [`Comment::raw`]"]
        Raw,
    }
    impl DocumentField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                Self::Children(idx) => {
                    assert_initial_index(*idx, index);
                    *idx = index;
                }
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum DocumentField {
        #[doc = "Represents [`Document::span`]"]
        Span,
        #[doc = "Represents [`Document::mode`]"]
        Mode,
        #[doc = "Represents [`Document::children`]"]
        Children(usize),
    }
    impl DocumentFragmentField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                Self::Children(idx) => {
                    assert_initial_index(*idx, index);
                    *idx = index;
                }
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum DocumentFragmentField {
        #[doc = "Represents [`DocumentFragment::span`]"]
        Span,
        #[doc = "Represents [`DocumentFragment::children`]"]
        Children(usize),
    }
    impl DocumentModeField {
        #[inline(always)]
        pub(crate) fn set_index(&mut self, _: usize) {
            swc_visit::wrong_ast_path();
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum DocumentModeField {
        #[doc = "Represents [`DocumentMode::NoQuirks`]"]
        NoQuirks,
        #[doc = "Represents [`DocumentMode::LimitedQuirks`]"]
        LimitedQuirks,
        #[doc = "Represents [`DocumentMode::Quirks`]"]
        Quirks,
    }
    impl DocumentTypeField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum DocumentTypeField {
        #[doc = "Represents [`DocumentType::span`]"]
        Span,
        #[doc = "Represents [`DocumentType::name`]"]
        Name,
        #[doc = "Represents [`DocumentType::public_id`]"]
        PublicId,
        #[doc = "Represents [`DocumentType::system_id`]"]
        SystemId,
        #[doc = "Represents [`DocumentType::raw`]"]
        Raw,
    }
    impl ElementField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                Self::Attributes(idx) => {
                    assert_initial_index(*idx, index);
                    *idx = index;
                }
                Self::Children(idx) => {
                    assert_initial_index(*idx, index);
                    *idx = index;
                }
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum ElementField {
        #[doc = "Represents [`Element::span`]"]
        Span,
        #[doc = "Represents [`Element::tag_name`]"]
        TagName,
        #[doc = "Represents [`Element::namespace`]"]
        Namespace,
        #[doc = "Represents [`Element::attributes`]"]
        Attributes(usize),
        #[doc = "Represents [`Element::children`]"]
        Children(usize),
        #[doc = "Represents [`Element::content`]"]
        Content,
        #[doc = "Represents [`Element::is_self_closing`]"]
        IsSelfClosing,
    }
    impl NamespaceField {
        #[inline(always)]
        pub(crate) fn set_index(&mut self, _: usize) {
            swc_visit::wrong_ast_path();
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum NamespaceField {
        #[doc = "Represents [`Namespace::HTML`]"]
        Html,
        #[doc = "Represents [`Namespace::MATHML`]"]
        Mathml,
        #[doc = "Represents [`Namespace::SVG`]"]
        Svg,
        #[doc = "Represents [`Namespace::XLINK`]"]
        Xlink,
        #[doc = "Represents [`Namespace::XML`]"]
        Xml,
        #[doc = "Represents [`Namespace::XMLNS`]"]
        Xmlns,
    }
    impl RawField {
        #[inline(always)]
        pub(crate) fn set_index(&mut self, _: usize) {
            swc_visit::wrong_ast_path();
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum RawField {
        #[doc = "Represents [`Raw::Same`]"]
        Same,
        #[doc = "Represents [`Raw::Atom`]"]
        Atom,
    }
    impl TextField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum TextField {
        #[doc = "Represents [`Text::span`]"]
        Span,
        #[doc = "Represents [`Text::data`]"]
        Data,
        #[doc = "Represents [`Text::raw`]"]
        Raw,
    }
    impl TokenField {
        #[inline(always)]
        pub(crate) fn set_index(&mut self, _: usize) {
            swc_visit::wrong_ast_path();
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum TokenField {
        #[doc = "Represents [`Token::Doctype`]"]
        Doctype,
        #[doc = "Represents [`Token::StartTag`]"]
        StartTag,
        #[doc = "Represents [`Token::EndTag`]"]
        EndTag,
        #[doc = "Represents [`Token::Comment`]"]
        Comment,
        #[doc = "Represents [`Token::Character`]"]
        Character,
        #[doc = "Represents [`Token::Eof`]"]
        Eof,
    }
    impl TokenAndSpanField {
        pub(crate) fn set_index(&mut self, index: usize) {
            match self {
                _ => swc_visit::wrong_ast_path(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum TokenAndSpanField {
        #[doc = "Represents [`TokenAndSpan::span`]"]
        Span,
        #[doc = "Represents [`TokenAndSpan::token`]"]
        Token,
    }
    #[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
    #[cfg_attr(feature = "serde-impl", derive(serde::Serialize, serde::Deserialize))]
    pub enum AstParentKind {
        Attribute(AttributeField),
        AttributeToken(AttributeTokenField),
        Child(ChildField),
        Comment(CommentField),
        Document(DocumentField),
        DocumentFragment(DocumentFragmentField),
        DocumentMode(DocumentModeField),
        DocumentType(DocumentTypeField),
        Element(ElementField),
        Namespace(NamespaceField),
        Raw(RawField),
        Text(TextField),
        Token(TokenField),
        TokenAndSpan(TokenAndSpanField),
    }
    impl ::swc_visit::ParentKind for AstParentKind {
        #[inline]
        fn set_index(&mut self, index: usize) {
            match self {
                Self::Attribute(v) => v.set_index(index),
                Self::AttributeToken(v) => v.set_index(index),
                Self::Child(v) => v.set_index(index),
                Self::Comment(v) => v.set_index(index),
                Self::Document(v) => v.set_index(index),
                Self::DocumentFragment(v) => v.set_index(index),
                Self::DocumentMode(v) => v.set_index(index),
                Self::DocumentType(v) => v.set_index(index),
                Self::Element(v) => v.set_index(index),
                Self::Namespace(v) => v.set_index(index),
                Self::Raw(v) => v.set_index(index),
                Self::Text(v) => v.set_index(index),
                Self::Token(v) => v.set_index(index),
                Self::TokenAndSpan(v) => v.set_index(index),
            }
        }
    }
    #[derive(Debug, Clone, Copy)]
    pub enum AstParentNodeRef<'ast> {
        Attribute(&'ast Attribute, AttributeField),
        AttributeToken(&'ast AttributeToken, AttributeTokenField),
        Child(&'ast Child, ChildField),
        Comment(&'ast Comment, CommentField),
        Document(&'ast Document, DocumentField),
        DocumentFragment(&'ast DocumentFragment, DocumentFragmentField),
        DocumentMode(&'ast DocumentMode, DocumentModeField),
        DocumentType(&'ast DocumentType, DocumentTypeField),
        Element(&'ast Element, ElementField),
        Namespace(&'ast Namespace, NamespaceField),
        Raw(&'ast Raw, RawField),
        Text(&'ast Text, TextField),
        Token(&'ast Token, TokenField),
        TokenAndSpan(&'ast TokenAndSpan, TokenAndSpanField),
    }
    impl<'ast> ::swc_visit::NodeRef for AstParentNodeRef<'ast> {
        type ParentKind = AstParentKind;

        #[inline(always)]
        fn kind(&self) -> AstParentKind {
            self.kind()
        }

        fn set_index(&mut self, index: usize) {
            match self {
                Self::Attribute(_, __field_kind) => __field_kind.set_index(index),
                Self::AttributeToken(_, __field_kind) => __field_kind.set_index(index),
                Self::Child(_, __field_kind) => __field_kind.set_index(index),
                Self::Comment(_, __field_kind) => __field_kind.set_index(index),
                Self::Document(_, __field_kind) => __field_kind.set_index(index),
                Self::DocumentFragment(_, __field_kind) => __field_kind.set_index(index),
                Self::DocumentMode(_, __field_kind) => __field_kind.set_index(index),
                Self::DocumentType(_, __field_kind) => __field_kind.set_index(index),
                Self::Element(_, __field_kind) => __field_kind.set_index(index),
                Self::Namespace(_, __field_kind) => __field_kind.set_index(index),
                Self::Raw(_, __field_kind) => __field_kind.set_index(index),
                Self::Text(_, __field_kind) => __field_kind.set_index(index),
                Self::Token(_, __field_kind) => __field_kind.set_index(index),
                Self::TokenAndSpan(_, __field_kind) => __field_kind.set_index(index),
            }
        }
    }
    #[cfg(any(docsrs, feature = "path"))]
    impl<'ast> AstParentNodeRef<'ast> {
        #[inline]
        pub fn kind(&self) -> AstParentKind {
            match self {
                Self::Attribute(_, __field_kind) => AstParentKind::Attribute(*__field_kind),
                Self::AttributeToken(_, __field_kind) => {
                    AstParentKind::AttributeToken(*__field_kind)
                }
                Self::Child(_, __field_kind) => AstParentKind::Child(*__field_kind),
                Self::Comment(_, __field_kind) => AstParentKind::Comment(*__field_kind),
                Self::Document(_, __field_kind) => AstParentKind::Document(*__field_kind),
                Self::DocumentFragment(_, __field_kind) => {
                    AstParentKind::DocumentFragment(*__field_kind)
                }
                Self::DocumentMode(_, __field_kind) => AstParentKind::DocumentMode(*__field_kind),
                Self::DocumentType(_, __field_kind) => AstParentKind::DocumentType(*__field_kind),
                Self::Element(_, __field_kind) => AstParentKind::Element(*__field_kind),
                Self::Namespace(_, __field_kind) => AstParentKind::Namespace(*__field_kind),
                Self::Raw(_, __field_kind) => AstParentKind::Raw(*__field_kind),
                Self::Text(_, __field_kind) => AstParentKind::Text(*__field_kind),
                Self::Token(_, __field_kind) => AstParentKind::Token(*__field_kind),
                Self::TokenAndSpan(_, __field_kind) => AstParentKind::TokenAndSpan(*__field_kind),
            }
        }
    }
}
impl<'ast> From<&'ast Attribute> for NodeRef<'ast> {
    fn from(node: &'ast Attribute) -> Self {
        NodeRef::Attribute(node)
    }
}
impl<'ast> From<&'ast AttributeToken> for NodeRef<'ast> {
    fn from(node: &'ast AttributeToken) -> Self {
        NodeRef::AttributeToken(node)
    }
}
impl<'ast> From<&'ast Child> for NodeRef<'ast> {
    fn from(node: &'ast Child) -> Self {
        NodeRef::Child(node)
    }
}
impl<'ast> From<&'ast Comment> for NodeRef<'ast> {
    fn from(node: &'ast Comment) -> Self {
        NodeRef::Comment(node)
    }
}
impl<'ast> From<&'ast Document> for NodeRef<'ast> {
    fn from(node: &'ast Document) -> Self {
        NodeRef::Document(node)
    }
}
impl<'ast> From<&'ast DocumentFragment> for NodeRef<'ast> {
    fn from(node: &'ast DocumentFragment) -> Self {
        NodeRef::DocumentFragment(node)
    }
}
impl<'ast> From<&'ast DocumentMode> for NodeRef<'ast> {
    fn from(node: &'ast DocumentMode) -> Self {
        NodeRef::DocumentMode(node)
    }
}
impl<'ast> From<&'ast DocumentType> for NodeRef<'ast> {
    fn from(node: &'ast DocumentType) -> Self {
        NodeRef::DocumentType(node)
    }
}
impl<'ast> From<&'ast Element> for NodeRef<'ast> {
    fn from(node: &'ast Element) -> Self {
        NodeRef::Element(node)
    }
}
impl<'ast> From<&'ast Namespace> for NodeRef<'ast> {
    fn from(node: &'ast Namespace) -> Self {
        NodeRef::Namespace(node)
    }
}
impl<'ast> From<&'ast Raw> for NodeRef<'ast> {
    fn from(node: &'ast Raw) -> Self {
        NodeRef::Raw(node)
    }
}
impl<'ast> From<&'ast Text> for NodeRef<'ast> {
    fn from(node: &'ast Text) -> Self {
        NodeRef::Text(node)
    }
}
impl<'ast> From<&'ast Token> for NodeRef<'ast> {
    fn from(node: &'ast Token) -> Self {
        NodeRef::Token(node)
    }
}
impl<'ast> From<&'ast TokenAndSpan> for NodeRef<'ast> {
    fn from(node: &'ast TokenAndSpan) -> Self {
        NodeRef::TokenAndSpan(node)
    }
}
#[derive(Debug, Clone, Copy)]
pub enum NodeRef<'ast> {
    Attribute(&'ast Attribute),
    AttributeToken(&'ast AttributeToken),
    Child(&'ast Child),
    Comment(&'ast Comment),
    Document(&'ast Document),
    DocumentFragment(&'ast DocumentFragment),
    DocumentMode(&'ast DocumentMode),
    DocumentType(&'ast DocumentType),
    Element(&'ast Element),
    Namespace(&'ast Namespace),
    Raw(&'ast Raw),
    Text(&'ast Text),
    Token(&'ast Token),
    TokenAndSpan(&'ast TokenAndSpan),
}
impl<'ast> NodeRef<'ast> {
    #[doc = r" This is not a part of semver-stable API. It is experimental and subject to change."]
    #[allow(unreachable_patterns)]
    pub fn experimental_raw_children<'a>(&'a self) -> Box<dyn 'a + Iterator<Item = NodeRef<'ast>>> {
        match self {
            NodeRef::Attribute(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>().chain(
                    node.namespace
                        .iter()
                        .flat_map(|item| ::std::iter::once(NodeRef::Namespace(&item))),
                );
                Box::new(iterator)
            }
            NodeRef::AttributeToken(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>();
                Box::new(iterator)
            }
            NodeRef::Child(node) => match node {
                Child::DocumentType(v0) => Box::new(::std::iter::once(NodeRef::DocumentType(v0))),
                Child::Element(v0) => Box::new(::std::iter::once(NodeRef::Element(v0))),
                Child::Text(v0) => Box::new(::std::iter::once(NodeRef::Text(v0))),
                Child::Comment(v0) => Box::new(::std::iter::once(NodeRef::Comment(v0))),
                _ => Box::new(::std::iter::empty::<NodeRef<'ast>>()),
            },
            NodeRef::Comment(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>();
                Box::new(iterator)
            }
            NodeRef::Document(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>()
                    .chain(::std::iter::once(NodeRef::DocumentMode(&node.mode)))
                    .chain(
                        node.children
                            .iter()
                            .flat_map(|item| ::std::iter::once(NodeRef::Child(&item))),
                    );
                Box::new(iterator)
            }
            NodeRef::DocumentFragment(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>().chain(
                    node.children
                        .iter()
                        .flat_map(|item| ::std::iter::once(NodeRef::Child(&item))),
                );
                Box::new(iterator)
            }
            NodeRef::DocumentMode(node) => match node {
                _ => Box::new(::std::iter::empty::<NodeRef<'ast>>()),
            },
            NodeRef::DocumentType(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>();
                Box::new(iterator)
            }
            NodeRef::Element(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>()
                    .chain(::std::iter::once(NodeRef::Namespace(&node.namespace)))
                    .chain(
                        node.attributes
                            .iter()
                            .flat_map(|item| ::std::iter::once(NodeRef::Attribute(&item))),
                    )
                    .chain(
                        node.children
                            .iter()
                            .flat_map(|item| ::std::iter::once(NodeRef::Child(&item))),
                    )
                    .chain(
                        node.content
                            .iter()
                            .flat_map(|item| ::std::iter::once(NodeRef::DocumentFragment(&item))),
                    );
                Box::new(iterator)
            }
            NodeRef::Namespace(node) => match node {
                _ => Box::new(::std::iter::empty::<NodeRef<'ast>>()),
            },
            NodeRef::Raw(node) => match node {
                _ => Box::new(::std::iter::empty::<NodeRef<'ast>>()),
            },
            NodeRef::Text(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>();
                Box::new(iterator)
            }
            NodeRef::Token(node) => match node {
                _ => Box::new(::std::iter::empty::<NodeRef<'ast>>()),
            },
            NodeRef::TokenAndSpan(node) => {
                let iterator = ::std::iter::empty::<NodeRef<'ast>>()
                    .chain(::std::iter::once(NodeRef::Token(&node.token)));
                Box::new(iterator)
            }
        }
    }
}
impl<'ast> NodeRef<'ast> {
    #[doc = r" Visit all nodes in self in preorder."]
    #[doc = r""]
    #[doc = r" This is not a part of semver-stable API. It is"]
    #[doc = r" experimental and subject to change."]
    pub fn experimental_traverse(&'ast self) -> Box<dyn 'ast + Iterator<Item = NodeRef<'ast>>> {
        let mut queue = std::collections::VecDeque::<NodeRef<'ast>>::new();
        queue.push_back(*self);
        Box::new(std::iter::from_fn(move || {
            let node: NodeRef<'ast> = queue.pop_front()?;
            {
                let children = node.experimental_raw_children();
                queue.extend(children);
            }
            Some(node)
        }))
    }
}
#[cfg(any(docsrs, feature = "path"))]
pub use self::fields::{AstParentKind, AstParentNodeRef};
