#version 330

layout(lines) in;
layout(triangle_strip, max_vertices = 60) out;
//layout(line_strip, max_vertices = 113) out;

const float PI = 3.14159265359f;

uniform mat3 normalMatrix;
uniform mat4 pmv;
uniform int segments = 2;
uniform float radius = 0.09f;
uniform float qradius = 0.02f;
uniform float qcutoff = -10.0;
uniform bool h_bonds = true;
uniform bool qPeakBonds = true;
uniform bool hideHydrogen = false;

in vec3 vPos[];
in float styleI[];
in float an[];
in float ph[];
in float sg[];

out vec3 Normal;
vec3 vert=vec3(0,0,0);
out float distance_from_start;
flat out int _style;
flat out int _an;
flat out int _sg;
flat out float ph_or_part;
flat out float bondlength;
out gl_PerVertex{
  vec4 gl_Position;
};


void main(void){
    if (((int(styleI[0])|(int(styleI[1])))&512)>0) return;
    if ((hideHydrogen)&&((an[0] == 0) || ( an[1] == 0))) return;
    vec4 start = gl_in[0].gl_Position;
    vec4 end = gl_in[1].gl_Position;
    start.w = 1.0;
    end.w = 1.0;
    vec3 direction   = normalize(end.xyz - start.xyz);
    float l = length(end.xyz - start.xyz);
    vec3 lot = (abs(dot(direction, vec3(1, 0, 0))) > 0.8)?
                (abs(dot(direction, vec3(0, 1, 0))) > 0.8)?
                normalize(cross(direction, vec3(0, 0, 1))):
                normalize(cross(direction, vec3(0, 1, 0))):
                normalize(cross(direction, vec3(1, 0, 0)));
    vec3 lot2 = normalize(cross(direction,lot));
    vec3 r = vec3(0,0,0);
    int toan = int(((an[0]<0)||(an[1]<0)) ? min(an[0], an[1]) : an[0] + 1000*an[1]);
    int tostyle = int(styleI[0]) + (int(styleI[1])<<14);
    float rad = (toan<0) ? qradius/20.0 : radius;
    //if (!h_bonds) return;
    if ((!h_bonds) && ((an[0] == 0) || ( an[1] == 0)) && (l > 1.3)) return; //h_bonds
    if ((toan==-1) && (!qPeakBonds)) return;
    if ((((an[0] == -1) || ( an[1] == -1))) && ((ph[0]<qcutoff) || (ph[1]<qcutoff))) return;
    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
        vert = start.xyz  + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalMatrix * r;
        bondlength = l;
        _an = toan;
        _sg = int(sg[0]);
        ph_or_part = ph[0];
        _style = tostyle;//abs(styleI[0]-styleI[1]);
        distance_from_start = 0.0;
        EmitVertex();
        vert = end.xyz  + rad * r;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalMatrix * r;
        distance_from_start = 1.0;
        bondlength = l;
        _an = toan;        
        _sg = int(sg[1]);
        ph_or_part = ph[1];
        _style = tostyle;//abs(styleI[0]-styleI[1]);
        EmitVertex();
    }
    EndPrimitive();
}
