/* Public domain. */

/* MT-unsafe */

#include <unistd.h>
#include <errno.h>
#include "allreadwrite.h"
#include "uint64.h"
#include "error.h"
#include "djbunix.h"
#include "sig.h"
#include "nsig.h"
#include "selfpipe.h"

static int selfpipe[2] = { -1, -1 } ;
static uint64 caught ;

static void selfpipe_trigger (int s)
{
  char c = (char)s ;
  fd_write(selfpipe[1], &c, 1) ;
}

static void selfpipe_close (void)
{
  register int e = errno ;
  fd_close(selfpipe[1]) ;
  fd_close(selfpipe[0]) ;
  selfpipe[0] = selfpipe[1] = -1 ;
  errno = e ;
}

int selfpipe_init (void)
{
  if (selfpipe[0] >= 0) return (errno = EBUSY, -1) ;
  if (pipe(selfpipe) == -1) return -1 ;
  if ((ndelay_on(selfpipe[1]) == -1)
   || (coe(selfpipe[1]) == -1)
   || (ndelay_on(selfpipe[0]) == -1)
   || (coe(selfpipe[0]) == -1))
    selfpipe_close() ;
  return selfpipe[0] ;
}

int selfpipe_trap (int sig)
{
  struct skasigaction ssa = { &selfpipe_trigger, SKASA_NOCLDSTOP | SKASA_MASKALL } ;
  if (sig_catcha(sig, &ssa) == -1) return -1 ;
  caught |= (1 << (sig-1)) ;
  return 0 ;
}

int selfpipe_read (void)
{
  char c ;
  register int r = sanitize_read((fd_read(selfpipe[0], &c, 1))) ;
  return (r <= 0) ? r : (int)c ;
}

void selfpipe_finish (void)
{
  register unsigned int i = 1 ;
  for (; i <= NSIG ; caught >>= 1, i++) if (caught & 1) sig_restore(i) ;
  selfpipe_close() ;
}
