-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings;

package Command_Line is
   subtype Memory_Limit_T is Natural range Natural'First .. Natural'Last / 1024;

   type Solver_T is (
                     Alt_Ergo,
                     CVC3,
                     CVC4_SMTLIB1,
                     CVC4,
                     Yices,
                     Z3);

   type Command_Line_Data_T is record
      Unit_Name    : E_Strings.T;
      Proof_Steps  : Natural;
      Time_Out     : Natural;
      Memory_Limit : Memory_Limit_T; --  In megabytes as opposed to kbytes
      Ignore_SIV   : Boolean;
      Plain        : Boolean;
      Show_Help    : Boolean;
      Solver       : Solver_T;
      User_Rules   : Boolean;
      Keep_Temp    : Boolean;
   end record;

   --  If you change any of those, please also update the help text in banner.adb.
   Default_Options : constant Command_Line_Data_T :=
     Command_Line_Data_T'
     (Unit_Name    => E_Strings.Empty_String,
      Proof_Steps  => 5000,
      Time_Out     => 0,
      Memory_Limit => 0,
      Ignore_SIV   => False,
      Plain        => False,
      Show_Help    => False,
      Solver       => Alt_Ergo,
      User_Rules   => True,
      Keep_Temp    => False);

   --  Parse command line arguments and options.
   procedure Initialize (Data  : out Command_Line_Data_T;
                         Ok    : out Boolean;
                         Error : out E_Strings.T);

   --  Set the exit status of the program to a non-zero value.
   procedure Set_Exit_Status_Error;

end Command_Line;
