
from dolfin_utils.pjobs import submit

# Defaults from main.cpp:
theta   = 0
sigma_0 = 15
K       =  0.876
C_compr = 10.0
bff     = 18.48
bfx     =  3.58
bxx     =  2.8

# Variations we want to test:
theta_values = (0, 22.5, 45, 77.5, 90)
sigma_0_values = (5, 15, 45)
C_compr_values = (1, 3, 10, 20, 50, 100)
bff_values = tuple(bff*s for s in (0.8, 1.0, 1.2))
bfx_values = tuple(bfx*s for s in (0.8, 1.0, 1.2))
bxx_values = tuple(bxx*s for s in (0.8, 1.0, 1.2))

# A smaller set for testing:
theta_values   = (0,)
sigma_0_values = (15,)
C_compr_values = (10,)
bff_values = (bff,)
bfx_values = (bfx,)
bxx_values = (bxx,)

# Queue all jobs!
appname = "demo"
names = []
jobs = []
for theta in theta_values:
    for sigma_0 in sigma_0_values:
        for C_compr in C_compr_values:
            for bff in bff_values:
                for bfx in bfx_values:
                    for bxx in bxx_values:
                        parameters = [\
                               ("theta", theta),
                               ("sigma_0", sigma_0),
                               ("C_compr", C_compr),
                               ("bff", bff),
                               ("bfx", bfx),
                               ("bxx", bxx),
                               ]
                        name = "%s__%s" % (appname, "__".join("%s_%s" % (a, b) for (a, b) in parameters))
                        cmd = "./%s %s" % (appname, " ".join("--%s=%s" % (a, b) for (a, b) in parameters))
                        jobs.append(cmd)
                        names.append(name)

submit(jobs, name=names, nodes=1, ppn=8, walltime=24)

