package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkInterface invokes the ecs.CreateNetworkInterface API synchronously
func (client *Client) CreateNetworkInterface(request *CreateNetworkInterfaceRequest) (response *CreateNetworkInterfaceResponse, err error) {
	response = CreateCreateNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkInterfaceWithChan invokes the ecs.CreateNetworkInterface API asynchronously
func (client *Client) CreateNetworkInterfaceWithChan(request *CreateNetworkInterfaceRequest) (<-chan *CreateNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkInterfaceWithCallback invokes the ecs.CreateNetworkInterface API asynchronously
func (client *Client) CreateNetworkInterfaceWithCallback(request *CreateNetworkInterfaceRequest, callback func(response *CreateNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkInterfaceRequest is the request struct for api CreateNetworkInterface
type CreateNetworkInterfaceRequest struct {
	*requests.RpcRequest
	QueueNumber                    requests.Integer             `position:"Query" name:"QueueNumber"`
	ResourceOwnerId                requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string                       `position:"Query" name:"ClientToken"`
	SecurityGroupId                string                       `position:"Query" name:"SecurityGroupId"`
	Description                    string                       `position:"Query" name:"Description"`
	SecondaryPrivateIpAddressCount requests.Integer             `position:"Query" name:"SecondaryPrivateIpAddressCount"`
	BusinessType                   string                       `position:"Query" name:"BusinessType"`
	ResourceGroupId                string                       `position:"Query" name:"ResourceGroupId"`
	InstanceType                   string                       `position:"Query" name:"InstanceType"`
	Tag                            *[]CreateNetworkInterfaceTag `position:"Query" name:"Tag"  type:"Repeated"`
	NetworkInterfaceName           string                       `position:"Query" name:"NetworkInterfaceName"`
	Visible                        requests.Boolean             `position:"Query" name:"Visible"`
	ResourceOwnerAccount           string                       `position:"Query" name:"ResourceOwnerAccount"`
	Ipv6AddressCount               requests.Integer             `position:"Query" name:"Ipv6AddressCount"`
	OwnerAccount                   string                       `position:"Query" name:"OwnerAccount"`
	QueuePairNumber                requests.Integer             `position:"Query" name:"QueuePairNumber"`
	OwnerId                        requests.Integer             `position:"Query" name:"OwnerId"`
	SecurityGroupIds               *[]string                    `position:"Query" name:"SecurityGroupIds"  type:"Repeated"`
	NetworkInterfaceTrafficMode    string                       `position:"Query" name:"NetworkInterfaceTrafficMode"`
	VSwitchId                      string                       `position:"Query" name:"VSwitchId"`
	PrivateIpAddress               *[]string                    `position:"Query" name:"PrivateIpAddress"  type:"Repeated"`
	PrimaryIpAddress               string                       `position:"Query" name:"PrimaryIpAddress"`
	Ipv6Address                    *[]string                    `position:"Query" name:"Ipv6Address"  type:"Repeated"`
}

// CreateNetworkInterfaceTag is a repeated param struct in CreateNetworkInterfaceRequest
type CreateNetworkInterfaceTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateNetworkInterfaceResponse is the response struct for api CreateNetworkInterface
type CreateNetworkInterfaceResponse struct {
	*responses.BaseResponse
	Status               string                                   `json:"Status" xml:"Status"`
	Type                 string                                   `json:"Type" xml:"Type"`
	VpcId                string                                   `json:"VpcId" xml:"VpcId"`
	NetworkInterfaceName string                                   `json:"NetworkInterfaceName" xml:"NetworkInterfaceName"`
	MacAddress           string                                   `json:"MacAddress" xml:"MacAddress"`
	NetworkInterfaceId   string                                   `json:"NetworkInterfaceId" xml:"NetworkInterfaceId"`
	ServiceID            int64                                    `json:"ServiceID" xml:"ServiceID"`
	OwnerId              string                                   `json:"OwnerId" xml:"OwnerId"`
	ServiceManaged       bool                                     `json:"ServiceManaged" xml:"ServiceManaged"`
	VSwitchId            string                                   `json:"VSwitchId" xml:"VSwitchId"`
	RequestId            string                                   `json:"RequestId" xml:"RequestId"`
	Description          string                                   `json:"Description" xml:"Description"`
	ResourceGroupId      string                                   `json:"ResourceGroupId" xml:"ResourceGroupId"`
	ZoneId               string                                   `json:"ZoneId" xml:"ZoneId"`
	PrivateIpAddress     string                                   `json:"PrivateIpAddress" xml:"PrivateIpAddress"`
	SecurityGroupIds     SecurityGroupIdsInCreateNetworkInterface `json:"SecurityGroupIds" xml:"SecurityGroupIds"`
	PrivateIpSets        PrivateIpSetsInCreateNetworkInterface    `json:"PrivateIpSets" xml:"PrivateIpSets"`
	Tags                 TagsInCreateNetworkInterface             `json:"Tags" xml:"Tags"`
	Ipv6Sets             Ipv6SetsInCreateNetworkInterface         `json:"Ipv6Sets" xml:"Ipv6Sets"`
}

// CreateCreateNetworkInterfaceRequest creates a request to invoke CreateNetworkInterface API
func CreateCreateNetworkInterfaceRequest() (request *CreateNetworkInterfaceRequest) {
	request = &CreateNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateNetworkInterface", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNetworkInterfaceResponse creates a response to parse from CreateNetworkInterface response
func CreateCreateNetworkInterfaceResponse() (response *CreateNetworkInterfaceResponse) {
	response = &CreateNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
