## TFSA-2021-142: FPE in `tf.raw_ops.UnravelIndex`

### CVE Number
CVE-2021-37668

### Impact
An attacker can cause denial of service in applications serving models using
`tf.raw_ops.UnravelIndex` by triggering a division by 0:

```python
import tensorflow as tf

tf.raw_ops.UnravelIndex(indices=-1, dims=[1,0,2])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/kernels/unravel_index_op.cc#L36)
does not check that the tensor subsumed by `dims` is not empty. Hence, if one
element of `dims` is 0, the implementation does a division by 0.

### Patches
We have patched the issue in GitHub commit
[a776040a5e7ebf76eeb7eb923bf1ae417dd4d233](https://github.com/tensorflow/tensorflow/commit/a776040a5e7ebf76eeb7eb923bf1ae417dd4d233).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
