/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef UKCCABOUT_H
#define UKCCABOUT_H

#include <QWidget>
#include <QDialog>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QTextEdit>
#include <QEvent>

#include "fixlabel.h"
#include "lightlabel.h"

class UkccAbout : public QDialog
{
    Q_OBJECT
public:
    explicit UkccAbout(QWidget *parent = nullptr);

protected:
    bool eventFilter(QObject *watch, QEvent *event);

private:
    QLabel *mIconLabel = nullptr;
    QLabel *mAppLabel = nullptr;
    LightLabel *mVersionLabel_1 = nullptr;
    LightLabel *mVersionLabel_2 = nullptr;
    LightLabel *mTipLabel_1 = nullptr;
    LightLabel *mTipLabel_2 = nullptr;

private:
    void initUI();
    void hideComponent();
    QString getUkccVersion();

signals:

};

#endif // UKCCABOUT_H
