%{

/*
 * +-------------------------------------------------------+
 * |                                                       |
 * |     videogen                                          |
 * |                                                       |
 * |     a simple XFree86 Modeline calculator              |
 * |     (c) 1997-2003, Szabolcs Rumi                      |   
 * |                                                       |
 * |     http://www.dynaweb.hu/opensource/videogen         |
 * |                                                       |
 * |     the videogen package is distributed under the     |
 * |     GNU General Public License Version 2 (GPLv2)      |
 * |                                                       |
 * +-------------------------------------------------------+   
 */





/* this should be generated as a case insensitive lexer */


#include <stdlib.h>

#include "config.h"
#include "videogen.h"
#include "cfg.tab.h"



unsigned int lexer_num_lines = 1;	/* start line counting from 1 */



%}



%option outfile="cfg.yy.c"
%option noyywrap



%%



=					{	return ('=');			}

[0-9]+[.][0-9]+				{	yylval.fval = atof (yytext);
						return (T_FLOAT);		}

[0-9]+					{	yylval.ival = atol (yytext);
						return (T_INTEGER);		}

yes|y|on				{	yylval.bval = 1;
						return (T_BOOLEAN);		}

no|n|off				{	yylval.bval = 0;
						return (T_BOOLEAN);		}

verbose					{	return (T_VERBOSE);		}

fbset					{	return (T_FBSET);		}

nvidia					{	return (T_NVIDIA);		}

mode					{	return (T_MODE);		}

max_dotclk				{	return (T_MAX_DOTCLK);		}

max_hfreq				{	return (T_MAX_HFREQ);		}

max_vfreq				{	return (T_MAX_VFREQ);		}

desired_vfreq				{	return (T_DESIRED_VFREQ);	}

hvisible				{	return (T_HVISIBLE);		}

vvisible				{	return (T_VVISIBLE);		}

hfporch					{	return (T_HFPORCH);		}

hbporch					{	return (T_HBPORCH);		}

hsync					{	return (T_HSYNC);		}

vfporch					{	return (T_VFPORCH);		}

vbporch					{	return (T_VBPORCH);		}

vsync					{	return (T_VSYNC);		}

;					{	return (';');			}

\n					{	lexer_num_lines++;
						return ('\n');			}

#[^\n]*					/* eat up shell-style comments */

[ \t]+					/* eat up blanks */

x					{	return ('x');			}

.					{	
						pmsg(VL_DEBUG, "[lexer] unrecognized character: %s\n", yytext );
					}



%%



/* EOF */
