/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.viewer.Viewer;

class PltFormattedReader
extends VolumeFileReader {
    PltFormattedReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
        this.jvxlData.wasCubic = true;
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.nSurfaces = 1;
    }

    protected void readParameters() throws Exception {
        int n = this.parseInt(this.readLine());
        int n2 = this.parseInt();
        this.nPointsX = this.parseInt(this.readLine());
        this.nPointsY = this.parseInt();
        this.nPointsZ = this.parseInt();
        this.jvxlFileHeaderBuffer.append("Plt formatted data (" + n + "," + n2 + ") " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " \nJmol " + Viewer.getJmolVersion() + '\n');
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
        float f = this.parseFloat(this.readLine().substring(0, 12));
        float f2 = this.parseFloat(this.line.substring(12, 24));
        float f3 = this.parseFloat(this.line.substring(24, 36));
        float f4 = this.parseFloat(this.line.substring(36, 48));
        float f5 = this.parseFloat(this.line.substring(48, 60));
        float f6 = this.parseFloat(this.line.substring(60, 72));
        this.volumetricOrigin.set(f, f3, f5);
        this.voxelCounts[0] = this.nPointsX;
        this.voxelCounts[1] = this.nPointsY;
        this.voxelCounts[2] = this.nPointsZ;
        this.volumetricVectors[0].set(0.0f, 0.0f, (f2 - f) / (float)this.nPointsX);
        this.volumetricVectors[1].set(0.0f, (f4 - f3) / (float)this.nPointsY, 0.0f);
        this.volumetricVectors[2].set((f6 - f5) / (float)this.nPointsZ, 0.0f, 0.0f);
    }
}

