#!/bin/sh

#DATE=`date +%y%m%d`
DATE=1

PKGNAME=xine-mozilla-plugin

# Some rpm checks
RPMVERSION=`rpm --version | tr [A-Z] [a-z] | sed -e 's/[a-z]//g' -e 's/\.//g' -e 's/ //g'`

# rpm version 4 return 40
if [ `expr $RPMVERSION` -lt 100 ]; then
  RPMVERSION=`expr $RPMVERSION \* 10`
fi

if [ `expr $RPMVERSION` -lt 400 ]; then
  RPM_BA="rpm -ba -ta ./xine-plugin-1.0.2.tar.gz"
  RPM_BB="rpm -bb -ta ./xine-plugin-1.0.2.tar.gz"
else
  RPM_BA="rpm -ta ./xine-plugin-1.0.2.tar.gz -ba"
  RPM_BB="rpm -ta ./xine-plugin-1.0.2.tar.gz -bb"
fi

##VERSION="@XINE_MAJOR@.@XINE_MINOR@.@XINE_SUB@"

echo "Creating tarball..."
rm -f config.cache && ./cvscompile.sh && make dist
rm -rf rpms
mkdir rpms

echo "*****************************************************"
echo
echo "building rpm for xine-plugin 1.0.2"
echo 
echo "current architecture:pentium"
echo "rpms will be copied to ./rpms directory"
echo
echo "*****************************************************"

export XINE_BUILD=i586-pc-linux-gnu

eval $RPM_BA

mv /usr/src/redhat/SRPMS/$PKGNAME-1.0.2-$DATE.src.rpm ./rpms/
mv /usr/src/redhat/RPMS/i386/$PKGNAME-1.0.2-$DATE.i386.rpm ./rpms/$PKGNAME-1.0.2-$DATE.i586.rpm

echo "Done."
